/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.support.service.ServiceHelper;

public class DefaultScheduledPollConsumer
extends ScheduledPollConsumer {
    private PollingConsumer pollingConsumer;
    private int timeout;

    public DefaultScheduledPollConsumer(DefaultEndpoint defaultEndpoint, Processor processor) {
        super(defaultEndpoint, processor);
    }

    public DefaultScheduledPollConsumer(Endpoint endpoint, Processor processor, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
    }

    @Override
    protected int poll() throws Exception {
        Exchange exchange;
        int messagesPolled = 0;
        while (this.isPollAllowed() && (exchange = this.timeout == 0 ? this.pollingConsumer.receiveNoWait() : (this.timeout < 0 ? this.pollingConsumer.receive() : this.pollingConsumer.receive((long)this.timeout))) != null) {
            this.log.trace("Polled {} {}", (Object)(++messagesPolled), (Object)exchange);
            if (exchange.hasOut()) {
                Exchange newExchange = this.getEndpoint().createExchange();
                newExchange.getIn().copyFrom(exchange.getOut());
                exchange = newExchange;
            }
            this.getProcessor().process(exchange);
        }
        return messagesPolled;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    protected void doStart() throws Exception {
        this.pollingConsumer = this.getEndpoint().createPollingConsumer();
        ServiceHelper.startService((Object)this.pollingConsumer);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.pollingConsumer);
        super.doStop();
    }
}

