/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.composite;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapOfMapsConverter
implements Converter {
    private static final String ATTRIBUTES_PROPERTY = "attributes";

    public boolean canConvert(Class type) {
        return true;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        context.convertAnother(source);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        while (reader.hasMoreChildren()) {
            this.readMap(reader, ret);
        }
        return ret;
    }

    Object readMap(HierarchicalStreamReader reader, Map<String, Object> map) {
        HashMap nested;
        String key;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            key = reader.getNodeName();
            HashMap<String, String> attributes = new HashMap<String, String>();
            Iterator attributeNames = reader.getAttributeNames();
            while (attributeNames.hasNext()) {
                String attributeName = (String)attributeNames.next();
                attributes.put(attributeName, reader.getAttribute(attributeName));
            }
            nested = this.readMap(reader, new HashMap<String, Object>());
            if (!attributes.isEmpty()) {
                if (nested instanceof String) {
                    HashMap newNested = new HashMap();
                    newNested.put(key, nested);
                    newNested.put(ATTRIBUTES_PROPERTY, attributes);
                    nested = newNested;
                } else {
                    Map nestedMap = nested;
                    nestedMap.put(ATTRIBUTES_PROPERTY, attributes);
                }
            }
        } else {
            return reader.getValue();
        }
        map.put(key, nested);
        reader.moveUp();
        this.readMap(reader, map);
        return map;
    }
}

