/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import java.io.File;
import java.net.URI;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachFileProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(AttachFileProducer.class);

    public AttachFileProducer(JiraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) {
        String issueKey = (String)exchange.getIn().getHeader("IssueKey", String.class);
        if (issueKey == null) {
            throw new IllegalArgumentException("Missing exchange input header named 'IssueKey', it should specify the issue key to attach a file.");
        }
        Object body = exchange.getIn().getBody();
        if (body instanceof GenericFile) {
            JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
            IssueRestClient issueClient = client.getIssueClient();
            Issue issue = (Issue)issueClient.getIssue(issueKey).claim();
            URI attachmentsUri = issue.getAttachmentsUri();
            GenericFile file = (GenericFile)body;
            issueClient.addAttachments(attachmentsUri, new File[]{(File)file.getFile()});
        } else {
            LOG.info("Jira AttachFileProducer can attach only one file on each invocation. The body instance is " + body.getClass().getName() + " but it accepts only GenericFile<File>. You can write a rooute processor to transform any incoming file to a Generic<File>");
        }
    }
}

