/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.domain.Issue;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;

public class NewIssuesConsumer
extends AbstractJiraConsumer {
    private final String jql;
    private long latestIssueId = -1L;

    public NewIssuesConsumer(JiraEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.jql = endpoint.getJql() + " ORDER BY key desc";
        List<Issue> issues = this.getIssues(this.jql, 0, 1, 1);
        if (issues.size() >= 1) {
            this.latestIssueId = issues.get(0).getId();
        }
    }

    @Override
    protected int poll() throws Exception {
        List<Issue> newIssues = this.getNewIssues();
        for (int i = newIssues.size() - 1; i > -1; --i) {
            Issue newIssue = newIssues.get(i);
            Exchange e = this.getEndpoint().createExchange();
            e.getIn().setBody((Object)newIssue);
            this.getProcessor().process(e);
        }
        return newIssues.size();
    }

    private List<Issue> getNewIssues() {
        String jqlFilter = "id > " + this.latestIssueId + " AND " + this.jql;
        List<Issue> issues = this.getIssues(jqlFilter, 0, 50, ((JiraEndpoint)this.getEndpoint()).getMaxResults());
        if (issues.size() > 0) {
            this.latestIssueId = issues.get(0).getId();
        }
        return issues;
    }
}

