/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import java.util.List;
import java.util.Stack;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewCommentsConsumer
extends AbstractJiraConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(NewCommentsConsumer.class);
    private Long lastCommentId = -1L;

    public NewCommentsConsumer(JiraEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        LOG.info("JIRA NewCommentsConsumer: Indexing current issue comments...");
        this.getComments(false);
    }

    @Override
    protected int poll() throws Exception {
        Stack<Comment> newComments = this.getComments(true);
        while (!newComments.empty()) {
            Comment newComment = newComments.pop();
            Exchange e = this.getEndpoint().createExchange();
            e.getIn().setBody((Object)newComment);
            this.getProcessor().process(e);
        }
        return newComments.size();
    }

    private Stack<Comment> getComments(boolean loadComments) {
        Stack<Comment> newComments = new Stack<Comment>();
        List<Issue> issues = this.getIssues();
        for (Issue issue : issues) {
            Issue fullIssue = (Issue)this.client().getIssueClient().getIssue(issue.getKey()).claim();
            for (Comment comment : fullIssue.getComments()) {
                if (comment.getId() <= this.lastCommentId) continue;
                this.lastCommentId = comment.getId();
                if (!loadComments) continue;
                newComments.push(comment);
            }
        }
        return newComments;
    }
}

