/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.util;

import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.telegram.model.IncomingMessage;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.component.telegram.model.Update;
import org.apache.camel.component.telegram.util.TelegramConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class TelegramConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, String.class, IncomingMessage.class, false, (type, exchange, value) -> TelegramConverter.toString((IncomingMessage)value));
        this.addTypeConverter(registry, String.class, Update.class, false, (type, exchange, value) -> TelegramConverter.toString((Update)value));
        this.addTypeConverter(registry, OutgoingMessage.class, byte[].class, false, (type, exchange, value) -> TelegramConverter.toOutgoingMessage((byte[])value, exchange));
        this.addTypeConverter(registry, OutgoingMessage.class, String.class, false, (type, exchange, value) -> TelegramConverter.toOutgoingMessage((String)value, exchange));
        this.addTypeConverter(registry, OutgoingMessage.class, Object.class, false, (type, exchange, value) -> TelegramConverter.toOutgoingMessage(value, exchange));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

