/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.component.telegram.model.ReplyKeyboardMarkup;

public class OutgoingTextMessage
extends OutgoingMessage {
    private static final long serialVersionUID = -8684079202025229263L;
    private String text;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="disable_web_page_preview")
    private Boolean disableWebPagePreview;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboardMarkup replyKeyboardMarkup;

    public OutgoingTextMessage() {
    }

    public OutgoingTextMessage(String text, String parseMode, Boolean disableWebPagePreview, ReplyKeyboardMarkup replyKeyboardMarkup) {
        this.text = text;
        this.parseMode = parseMode;
        this.disableWebPagePreview = disableWebPagePreview;
        this.replyKeyboardMarkup = replyKeyboardMarkup;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    public void setDisableWebPagePreview(Boolean disableWebPagePreview) {
        this.disableWebPagePreview = disableWebPagePreview;
    }

    public ReplyKeyboardMarkup getReplyKeyboardMarkup() {
        return this.replyKeyboardMarkup;
    }

    public void setReplyKeyboardMarkup(ReplyKeyboardMarkup replyKeyboardMarkup) {
        this.replyKeyboardMarkup = replyKeyboardMarkup;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("OutgoingTextMessage{");
        sb.append("text='").append(this.text).append('\'');
        sb.append(", parseMode='").append(this.parseMode).append('\'');
        sb.append(", disableWebPagePreview=").append(this.disableWebPagePreview).append('\'');
        sb.append(", replyKeyboardMarkup=").append(this.replyKeyboardMarkup);
        sb.append('}');
        sb.append(' ');
        sb.append(super.toString());
        return sb.toString();
    }

    public static class Builder {
        private String text;
        private String parseMode;
        private Boolean disableWebPagePreview;
        private ReplyKeyboardMarkup replyKeyboardMarkup;

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder disableWebPagePreview(Boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return this;
        }

        public Builder replyKeyboardMarkup(ReplyKeyboardMarkup replyKeyboardMarkup) {
            this.replyKeyboardMarkup = replyKeyboardMarkup;
            return this;
        }

        public OutgoingTextMessage build() {
            return new OutgoingTextMessage(this.text, this.parseMode, this.disableWebPagePreview, this.replyKeyboardMarkup);
        }
    }
}

