/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import java.util.Collections;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramConsumer;
import org.apache.camel.component.telegram.TelegramProducer;
import org.apache.camel.component.telegram.TelegramService;
import org.apache.camel.component.telegram.TelegramServiceProvider;
import org.apache.camel.component.telegram.TelegramWebhookProcessor;
import org.apache.camel.component.telegram.model.Update;
import org.apache.camel.component.telegram.util.TelegramMessageHelper;
import org.apache.camel.component.webhook.WebhookCapableEndpoint;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.18.0", scheme="telegram", title="Telegram", syntax="telegram:type/authorizationToken", label="chat")
public class TelegramEndpoint
extends ScheduledPollEndpoint
implements WebhookCapableEndpoint {
    @UriParam
    private TelegramConfiguration configuration;
    private WebhookConfiguration webhookConfiguration;

    public TelegramEndpoint(String endpointUri, Component component, TelegramConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new TelegramProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        TelegramConsumer consumer = new TelegramConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Exchange createExchange(Update update) {
        Exchange exchange = super.createExchange();
        TelegramMessageHelper.populateExchange(exchange, update);
        return exchange;
    }

    public Processor createWebhookHandler(Processor next) {
        return new TelegramWebhookProcessor(next);
    }

    public void registerWebhook() throws Exception {
        TelegramService service = TelegramServiceProvider.get().getService();
        if (!service.setWebhook(this.configuration.getAuthorizationToken(), this.webhookConfiguration.computeFullExternalUrl())) {
            throw new RuntimeCamelException("The Telegram API refused to register a webhook");
        }
    }

    public void unregisterWebhook() throws Exception {
        TelegramService service = TelegramServiceProvider.get().getService();
        if (!service.removeWebhook(this.configuration.getAuthorizationToken())) {
            throw new RuntimeCamelException("The Telegram API refused to unregister the webhook");
        }
    }

    public WebhookConfiguration getWebhookConfiguration() {
        return this.webhookConfiguration;
    }

    public void setWebhookConfiguration(WebhookConfiguration webhookConfiguration) {
        this.webhookConfiguration = webhookConfiguration;
    }

    public List<String> getWebhookMethods() {
        return Collections.singletonList("POST");
    }

    public TelegramConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TelegramConfiguration configuration) {
        this.configuration = configuration;
    }
}

