/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import java.util.Date;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.scheduler.SchedulerEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;

public class SchedulerConsumer
extends ScheduledPollConsumer {
    public SchedulerConsumer(SchedulerEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public SchedulerEndpoint getEndpoint() {
        return (SchedulerEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        return this.sendTimerExchange();
    }

    protected int sendTimerExchange() {
        final Exchange exchange = this.getEndpoint().createExchange();
        exchange.setProperty("CamelTimerName", (Object)this.getEndpoint().getName());
        Date now = new Date();
        exchange.setProperty("CamelTimerFiredTime", (Object)now);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Timer {} is firing", (Object)this.getEndpoint().getName());
        }
        if (!this.getEndpoint().isSynchronous()) {
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    if (exchange.getException() != null) {
                        SchedulerConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                    }
                }
            });
        } else {
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
        boolean polled = (Boolean)exchange.getProperty("CamelSchedulerPolledMessages", (Object)true, Boolean.TYPE);
        return polled ? 1 : 0;
    }

    protected void doStart() throws Exception {
        this.getEndpoint().onConsumerStart(this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.getEndpoint().onConsumerStop(this);
        super.doStop();
    }
}

