/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;

public class SSHPublicKeyHolder {
    private static final String SSH_RSA = "ssh-rsa";
    private static final String SSH_DSS = "ssh-dss";
    private static final String SSH_ECDSA = "ecdsa-sha2-nistp256";
    private static final String SSH_ED25519 = "ssh-ed25519";
    private String keyType;
    private BigInteger e;
    private BigInteger m;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private BigInteger y;

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public BigInteger getE() {
        return this.e;
    }

    public void setE(BigInteger e) {
        this.e = e;
    }

    public BigInteger getM() {
        return this.m;
    }

    public void setM(BigInteger m) {
        this.m = m;
    }

    public BigInteger getG() {
        return this.g;
    }

    public void setG(BigInteger g) {
        this.g = g;
    }

    public BigInteger getP() {
        return this.p;
    }

    public void setP(BigInteger p) {
        this.p = p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public void setQ(BigInteger q) {
        this.q = q;
    }

    public BigInteger getY() {
        return this.y;
    }

    public void setY(BigInteger y) {
        this.y = y;
    }

    public void push(byte[] keyPart) {
        if (this.keyType == null) {
            this.keyType = new String(keyPart, Charset.forName("UTF-8"));
            return;
        }
        if (SSH_RSA.equals(this.keyType)) {
            if (this.e == null) {
                this.e = new BigInteger(keyPart);
                return;
            }
            if (this.m == null) {
                this.m = new BigInteger(keyPart);
                return;
            }
        }
        if (SSH_DSS.equals(this.keyType)) {
            if (this.p == null) {
                this.p = new BigInteger(keyPart);
            }
            if (this.q == null) {
                this.q = new BigInteger(keyPart);
            }
            if (this.g == null) {
                this.g = new BigInteger(keyPart);
            }
            if (this.y == null) {
                this.y = new BigInteger(keyPart);
            }
        }
    }

    public PublicKey toPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory factory;
        KeySpec dsaPublicKeySpec;
        PublicKey returnValue = null;
        if (SSH_RSA.equals(this.keyType)) {
            dsaPublicKeySpec = new RSAPublicKeySpec(this.m, this.e);
            factory = KeyFactory.getInstance("RSA");
            returnValue = factory.generatePublic(dsaPublicKeySpec);
        }
        if (SSH_DSS.equals(this.keyType)) {
            dsaPublicKeySpec = new DSAPublicKeySpec(this.y, this.p, this.q, this.g);
            factory = KeyFactory.getInstance("DSA");
            returnValue = factory.generatePublic(dsaPublicKeySpec);
        }
        if (SSH_ED25519.equals(this.keyType)) {
            throw new UnsupportedOperationException();
        }
        if (SSH_ECDSA.equals(this.keyType)) {
            throw new UnsupportedOperationException();
        }
        return returnValue;
    }
}

