/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.eks;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.eks.AmazonEKS;
import com.amazonaws.services.eks.model.CreateClusterRequest;
import com.amazonaws.services.eks.model.CreateClusterResult;
import com.amazonaws.services.eks.model.DeleteClusterRequest;
import com.amazonaws.services.eks.model.DeleteClusterResult;
import com.amazonaws.services.eks.model.DescribeClusterRequest;
import com.amazonaws.services.eks.model.DescribeClusterResult;
import com.amazonaws.services.eks.model.ListClustersRequest;
import com.amazonaws.services.eks.model.ListClustersResult;
import com.amazonaws.services.eks.model.VpcConfigRequest;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.eks.EKSConfiguration;
import org.apache.camel.component.aws.eks.EKSEndpoint;
import org.apache.camel.component.aws.eks.EKSOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class EKSProducer
extends DefaultProducer {
    private transient String eksProducerToString;

    public EKSProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listClusters: {
                this.listClusters(this.getEndpoint().getEksClient(), exchange);
                break;
            }
            case describeCluster: {
                this.describeCluster(this.getEndpoint().getEksClient(), exchange);
                break;
            }
            case createCluster: {
                this.createCluster(this.getEndpoint().getEksClient(), exchange);
                break;
            }
            case deleteCluster: {
                this.deleteCluster(this.getEndpoint().getEksClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private EKSOperations determineOperation(Exchange exchange) {
        EKSOperations operation = (EKSOperations)((Object)exchange.getIn().getHeader("CamelAwsEKSOperation", EKSOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected EKSConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.eksProducerToString == null) {
            this.eksProducerToString = "EKSProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.eksProducerToString;
    }

    public EKSEndpoint getEndpoint() {
        return (EKSEndpoint)super.getEndpoint();
    }

    private void listClusters(AmazonEKS eksClient, Exchange exchange) {
        ListClustersResult result;
        ListClustersRequest request = new ListClustersRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSMaxResults"))) {
            int maxRes = (Integer)exchange.getIn().getHeader("CamelAwsEKSMaxResults", Integer.class);
            request.withMaxResults(Integer.valueOf(maxRes));
        }
        try {
            result = eksClient.listClusters(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("List Clusters command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = EKSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createCluster(AmazonEKS eksClient, Exchange exchange) {
        CreateClusterResult result;
        CreateClusterRequest request = new CreateClusterRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSClusterName"))) {
            String name = (String)exchange.getIn().getHeader("CamelAwsEKSClusterName", String.class);
            request.withName(name);
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSRoleARN"))) {
            String roleArn = (String)exchange.getIn().getHeader("CamelAwsEKSRoleARN", String.class);
            request.withRoleArn(roleArn);
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSVPCConfig"))) {
            VpcConfigRequest vpcConfig = (VpcConfigRequest)exchange.getIn().getHeader("CamelAwsEKSVPCConfig", VpcConfigRequest.class);
            request.withResourcesVpcConfig(vpcConfig);
        }
        try {
            result = eksClient.createCluster(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Create Cluster command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = EKSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeCluster(AmazonEKS eksClient, Exchange exchange) {
        DescribeClusterResult result;
        DescribeClusterRequest request = new DescribeClusterRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSClusterName"))) {
            throw new IllegalArgumentException("Cluster name must be specified");
        }
        String name = (String)exchange.getIn().getHeader("CamelAwsEKSClusterName", String.class);
        request.withName(name);
        try {
            result = eksClient.describeCluster(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Describe Cluster command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = EKSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteCluster(AmazonEKS eksClient, Exchange exchange) {
        DeleteClusterResult result;
        DeleteClusterRequest request = new DeleteClusterRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSClusterName"))) {
            throw new IllegalArgumentException("Cluster name must be specified");
        }
        String name = (String)exchange.getIn().getHeader("CamelAwsEKSClusterName", String.class);
        request.withName(name);
        try {
            result = eksClient.deleteCluster(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Delete Cluster command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = EKSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }
}

