/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import java.io.InputStream;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.converter.CxfConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.cxf.message.MessageContentsList;

public class CxfConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, InputStream.class, Response.class, false, (type, exchange, value) -> CxfConverter.toInputStream((Response)value, exchange));
        this.addTypeConverter(registry, InputStream.class, SOAPMessage.class, false, (type, exchange, value) -> CxfConverter.soapMessageToInputStream((SOAPMessage)value, exchange));
        this.addTypeConverter(registry, Object[].class, Object.class, false, (type, exchange, value) -> CxfConverter.toArray(value));
        this.addTypeConverter(registry, String.class, SOAPMessage.class, false, (type, exchange, value) -> CxfConverter.soapMessageToString((SOAPMessage)value, exchange));
        this.addTypeConverter(registry, QName.class, String.class, false, (type, exchange, value) -> CxfConverter.toQName((String)value));
        this.addTypeConverter(registry, DataFormat.class, String.class, false, (type, exchange, value) -> CxfConverter.toDataFormat((String)value));
        this.addTypeConverter(registry, MessageContentsList.class, Object[].class, false, (type, exchange, value) -> CxfConverter.toMessageContentsList((Object[])value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        this.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> CxfConverter.convertTo(type, exchange, value, registry));
    }

    private void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

