/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.component.aws.sqs.MessageDeduplicationIdStrategy;
import org.apache.camel.component.aws.sqs.MessageGroupIdStrategy;
import org.apache.camel.component.aws.sqs.SqsConfiguration;
import org.apache.camel.component.aws.sqs.SqsEndpoint;
import org.apache.camel.component.aws.sqs.SqsOperations;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class SqsProducer
extends DefaultProducer {
    private transient String sqsProducerToString;

    public SqsProducer(SqsEndpoint endpoint) throws NoFactoryAvailableException {
        super((Endpoint)endpoint);
        if (endpoint.getConfiguration().isFifoQueue() && ObjectHelper.isEmpty((Object)this.getEndpoint().getConfiguration().getMessageGroupIdStrategy())) {
            throw new IllegalArgumentException("messageGroupIdStrategy must be set for FIFO queues.");
        }
    }

    public void process(Exchange exchange) throws Exception {
        SqsOperations operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            this.processSingleMessage(exchange);
        } else {
            switch (operation) {
                case sendBatchMessage: {
                    this.sendBatchMessage(this.getClient(), exchange);
                    break;
                }
                case deleteMessage: {
                    this.deleteMessage(this.getClient(), exchange);
                    break;
                }
                case listQueues: {
                    this.listQueues(this.getClient(), exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    public void processSingleMessage(Exchange exchange) {
        String body = (String)exchange.getIn().getBody(String.class);
        SendMessageRequest request = new SendMessageRequest(this.getQueueUrl(), body);
        request.setMessageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
        this.addDelay(request, exchange);
        this.configureFifoAttributes(request, exchange);
        this.log.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        SendMessageResult result = this.getClient().sendMessage(request);
        this.log.trace("Received result [{}]", (Object)result);
        Message message = SqsProducer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsSqsMessageId", (Object)result.getMessageId());
        message.setHeader("CamelAwsSqsMD5OfBody", (Object)result.getMD5OfMessageBody());
    }

    private void sendBatchMessage(AmazonSQS amazonSQS, Exchange exchange) {
        SendMessageBatchRequest request = new SendMessageBatchRequest(this.getQueueUrl());
        ArrayList<SendMessageBatchRequestEntry> entries = new ArrayList<SendMessageBatchRequestEntry>();
        if (exchange.getIn().getBody() instanceof Iterable) {
            Iterable c = (Iterable)exchange.getIn().getBody(Iterable.class);
            for (String object : c) {
                SendMessageBatchRequestEntry entry = new SendMessageBatchRequestEntry();
                entry.setId(UUID.randomUUID().toString());
                entry.setMessageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
                entry.setMessageBody(object);
                this.addDelay(entry, exchange);
                this.configureFifoAttributes(entry, exchange);
                entries.add(entry);
            }
            request.setEntries(entries);
            SendMessageBatchResult result = amazonSQS.sendMessageBatch(request);
            Message message = SqsProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        } else {
            request = (SendMessageBatchRequest)exchange.getIn().getBody(SendMessageBatchRequest.class);
            SendMessageBatchResult result = amazonSQS.sendMessageBatch(request);
            Message message = SqsProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteMessage(AmazonSQS amazonSQS, Exchange exchange) {
        String receiptHandle = (String)exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class);
        DeleteMessageRequest request = new DeleteMessageRequest();
        request.setQueueUrl(this.getQueueUrl());
        if (ObjectHelper.isEmpty((Object)receiptHandle)) {
            throw new IllegalArgumentException("Receipt Handle must be specified for the operation deleteMessage");
        }
        request.setReceiptHandle(receiptHandle);
        DeleteMessageResult result = new DeleteMessageResult();
        result = amazonSQS.deleteMessage(request);
        Message message = SqsProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listQueues(AmazonSQS amazonSQS, Exchange exchange) {
        ListQueuesRequest request = new ListQueuesRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSqsPrefix"))) {
            request.setQueueNamePrefix((String)exchange.getIn().getHeader("CamelAwsSqsPrefix", String.class));
        }
        ListQueuesResult result = new ListQueuesResult();
        result = amazonSQS.listQueues(request);
        Message message = SqsProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void configureFifoAttributes(SendMessageRequest request, Exchange exchange) {
        if (this.getEndpoint().getConfiguration().isFifoQueue()) {
            MessageGroupIdStrategy messageGroupIdStrategy = this.getEndpoint().getConfiguration().getMessageGroupIdStrategy();
            String messageGroupId = messageGroupIdStrategy.getMessageGroupId(exchange);
            request.setMessageGroupId(messageGroupId);
            MessageDeduplicationIdStrategy messageDeduplicationIdStrategy = this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy();
            String messageDeduplicationId = messageDeduplicationIdStrategy.getMessageDeduplicationId(exchange);
            request.setMessageDeduplicationId(messageDeduplicationId);
        }
    }

    private void configureFifoAttributes(SendMessageBatchRequestEntry request, Exchange exchange) {
        if (this.getEndpoint().getConfiguration().isFifoQueue()) {
            MessageGroupIdStrategy messageGroupIdStrategy = this.getEndpoint().getConfiguration().getMessageGroupIdStrategy();
            String messageGroupId = messageGroupIdStrategy.getMessageGroupId(exchange);
            request.setMessageGroupId(messageGroupId);
            MessageDeduplicationIdStrategy messageDeduplicationIdStrategy = this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy();
            String messageDeduplicationId = messageDeduplicationIdStrategy.getMessageDeduplicationId(exchange);
            request.setMessageDeduplicationId(messageDeduplicationId);
        }
    }

    private void addDelay(SendMessageRequest request, Exchange exchange) {
        Integer delayValue;
        Integer headerValue = (Integer)exchange.getIn().getHeader("CamelAwsSqsDelaySeconds", Integer.class);
        if (headerValue == null) {
            this.log.trace("Using the config delay");
            delayValue = this.getEndpoint().getConfiguration().getDelaySeconds();
        } else {
            this.log.trace("Using the header delay");
            delayValue = headerValue;
        }
        this.log.trace("found delay: {}", (Object)delayValue);
        request.setDelaySeconds(delayValue == null ? Integer.valueOf(0) : delayValue);
    }

    private void addDelay(SendMessageBatchRequestEntry request, Exchange exchange) {
        Integer delayValue;
        Integer headerValue = (Integer)exchange.getIn().getHeader("CamelAwsSqsDelaySeconds", Integer.class);
        if (headerValue == null) {
            this.log.trace("Using the config delay");
            delayValue = this.getEndpoint().getConfiguration().getDelaySeconds();
        } else {
            this.log.trace("Using the header delay");
            delayValue = headerValue;
        }
        this.log.trace("found delay: {}", (Object)delayValue);
        request.setDelaySeconds(delayValue == null ? Integer.valueOf(0) : delayValue);
    }

    protected AmazonSQS getClient() {
        return this.getEndpoint().getClient();
    }

    protected String getQueueUrl() {
        return this.getEndpoint().getQueueUrl();
    }

    protected SqsConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public SqsEndpoint getEndpoint() {
        return (SqsEndpoint)super.getEndpoint();
    }

    public String toString() {
        if (this.sqsProducerToString == null) {
            this.sqsProducerToString = "SqsProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sqsProducerToString;
    }

    Map<String, MessageAttributeValue> translateAttributes(Map<String, Object> headers, Exchange exchange) {
        HashMap<String, MessageAttributeValue> result = new HashMap<String, MessageAttributeValue>();
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            MessageAttributeValue mav;
            if (headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange)) continue;
            Object value = entry.getValue();
            if (value instanceof String && !((String)value).isEmpty()) {
                mav = new MessageAttributeValue();
                mav.setDataType("String");
                mav.withStringValue((String)value);
                result.put(entry.getKey(), mav);
                continue;
            }
            if (value instanceof ByteBuffer) {
                mav = new MessageAttributeValue();
                mav.setDataType("Binary");
                mav.withBinaryValue((ByteBuffer)value);
                result.put(entry.getKey(), mav);
                continue;
            }
            if (value instanceof Boolean) {
                mav = new MessageAttributeValue();
                mav.setDataType("Number.Boolean");
                mav.withStringValue((Boolean)value != false ? "1" : "0");
                result.put(entry.getKey(), mav);
                continue;
            }
            if (value instanceof Number) {
                mav = new MessageAttributeValue();
                String dataType = value instanceof Integer ? "Number.int" : (value instanceof Byte ? "Number.byte" : (value instanceof Double ? "Number.double" : (value instanceof Float ? "Number.float" : (value instanceof Long ? "Number.long" : (value instanceof Short ? "Number.short" : "Number")))));
                mav.setDataType(dataType);
                mav.withStringValue(((Number)value).toString());
                result.put(entry.getKey(), mav);
                continue;
            }
            if (value instanceof Date) {
                mav = new MessageAttributeValue();
                mav.setDataType("String");
                mav.withStringValue(value.toString());
                result.put(entry.getKey(), mav);
                continue;
            }
            this.log.warn("Cannot put the message header key={}, value={} into Sqs MessageAttribute", (Object)entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    private SqsOperations determineOperation(Exchange exchange) {
        SqsOperations operation = (SqsOperations)((Object)exchange.getIn().getHeader("CamelAwsSqsOperation", SqsOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }
}

