/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.rest;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.processor.RestBindingAdvice;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.PropertyBindingSupport;

public class RestBindingReifier {
    private final RestBindingDefinition definition;

    public RestBindingReifier(RestBindingDefinition definition) {
        this.definition = definition;
    }

    public RestBindingAdvice createRestBindingAdvice(RouteContext routeContext) throws Exception {
        String typeName;
        CamelContext context = routeContext.getCamelContext();
        RestConfiguration config = context.getRestConfiguration(this.definition.getComponent(), true);
        String mode = config.getBindingMode().name();
        if (this.definition.getBindingMode() != null) {
            mode = this.definition.getBindingMode().name();
        }
        boolean cors = config.isEnableCORS();
        if (this.definition.getEnableCORS() != null) {
            cors = this.definition.getEnableCORS();
        }
        boolean skip = config.isSkipBindingOnErrorCode();
        if (this.definition.getSkipBindingOnErrorCode() != null) {
            skip = this.definition.getSkipBindingOnErrorCode();
        }
        boolean validation = config.isClientRequestValidation();
        if (this.definition.getClientRequestValidation() != null) {
            validation = this.definition.getClientRequestValidation();
        }
        Map corsHeaders = config.getCorsHeaders();
        if (mode == null || "off".equals(mode)) {
            return new RestBindingAdvice(context, null, null, null, null, this.definition.getConsumes(), this.definition.getProduces(), mode, skip, validation, cors, corsHeaders, this.definition.getDefaultValues(), this.definition.getRequiredBody() != null ? this.definition.getRequiredBody() : false, this.definition.getRequiredQueryParameters(), this.definition.getRequiredHeaders());
        }
        DataFormat json = null;
        DataFormat outJson = null;
        if (mode.contains("json") || "auto".equals(mode)) {
            String name = config.getJsonDataFormat();
            if (name != null) {
                Object instance = context.getRegistry().lookupByName(name);
                if (instance != null) {
                    throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "json-jackson";
            }
            json = context.resolveDataFormat(name);
            outJson = context.resolveDataFormat(name);
            if (json != null) {
                Class clazz = null;
                String type = this.definition.getType();
                if (type != null) {
                    String typeName2 = type.endsWith("[]") ? type.substring(0, type.length() - 2) : type;
                    clazz = context.getClassResolver().resolveMandatoryClass(typeName2);
                }
                if (clazz != null) {
                    IntrospectionSupport.setProperty((TypeConverter)context.getTypeConverter(), (Object)json, (String)"unmarshalType", clazz);
                    IntrospectionSupport.setProperty((TypeConverter)context.getTypeConverter(), (Object)json, (String)"useList", (Object)type.endsWith("[]"));
                }
                this.setAdditionalConfiguration(config, context, json, "json.in.");
                Class outClazz = null;
                String outType = this.definition.getOutType();
                if (outType != null) {
                    typeName = outType.endsWith("[]") ? outType.substring(0, outType.length() - 2) : outType;
                    outClazz = context.getClassResolver().resolveMandatoryClass(typeName);
                }
                if (outClazz != null) {
                    IntrospectionSupport.setProperty((TypeConverter)context.getTypeConverter(), (Object)outJson, (String)"unmarshalType", outClazz);
                    IntrospectionSupport.setProperty((TypeConverter)context.getTypeConverter(), (Object)outJson, (String)"useList", (Object)outType.endsWith("[]"));
                }
                this.setAdditionalConfiguration(config, context, outJson, "json.out.");
            }
        }
        DataFormat jaxb = null;
        DataFormat outJaxb = null;
        if (mode.contains("xml") || "auto".equals(mode)) {
            String name = config.getXmlDataFormat();
            if (name != null) {
                Object instance = context.getRegistry().lookupByName(name);
                if (instance != null) {
                    throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "jaxb";
            }
            jaxb = context.resolveDataFormat(name);
            outJaxb = context.resolveDataFormat(name);
            if (mode.contains("xml") && jaxb == null) {
                throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
            }
            if (jaxb != null) {
                JAXBContext jc;
                Class clazz = null;
                String type = this.definition.getType();
                if (type != null) {
                    typeName = type.endsWith("[]") ? type.substring(0, type.length() - 2) : type;
                    clazz = context.getClassResolver().resolveMandatoryClass(typeName);
                }
                if (clazz != null) {
                    JAXBContext jc2 = JAXBContext.newInstance((Class[])new Class[]{clazz});
                    IntrospectionSupport.setProperty((TypeConverter)context.getTypeConverter(), (Object)jaxb, (String)"context", (Object)jc2);
                }
                this.setAdditionalConfiguration(config, context, jaxb, "xml.in.");
                Class outClazz = null;
                String outType = this.definition.getOutType();
                if (outType != null) {
                    String typeName3 = outType.endsWith("[]") ? outType.substring(0, outType.length() - 2) : outType;
                    outClazz = context.getClassResolver().resolveMandatoryClass(typeName3);
                }
                if (outClazz != null) {
                    jc = JAXBContext.newInstance((Class[])new Class[]{outClazz});
                    IntrospectionSupport.setProperty((TypeConverter)context.getTypeConverter(), (Object)outJaxb, (String)"context", (Object)jc);
                } else if (clazz != null) {
                    jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                    IntrospectionSupport.setProperty((TypeConverter)context.getTypeConverter(), (Object)outJaxb, (String)"context", (Object)jc);
                }
                this.setAdditionalConfiguration(config, context, outJaxb, "xml.out.");
            }
        }
        return new RestBindingAdvice(context, json, jaxb, outJson, outJaxb, this.definition.getConsumes(), this.definition.getProduces(), mode, skip, validation, cors, corsHeaders, this.definition.getDefaultValues(), this.definition.getRequiredBody() != null ? this.definition.getRequiredBody() : false, this.definition.getRequiredQueryParameters(), this.definition.getRequiredHeaders());
    }

    private void setAdditionalConfiguration(RestConfiguration config, CamelContext context, DataFormat dataFormat, String prefix) throws Exception {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap copy = new HashMap();
            for (Map.Entry entry : config.getDataFormatProperties().entrySet()) {
                String key = (String)entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            PropertyBindingSupport.bindProperties((CamelContext)context, (Object)dataFormat, copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }
}

