/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.errorhandler.DeadLetterChannelReifier;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerRefReifier;
import org.apache.camel.reifier.errorhandler.NoErrorHandlerReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class ErrorHandlerReifier<T extends ErrorHandlerBuilderSupport> {
    public static final String DEFAULT_ERROR_HANDLER_BUILDER = "CamelDefaultErrorHandlerBuilder";
    private static final Map<Class<?>, Function<ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>>> ERROR_HANDLERS;
    protected T definition;

    ErrorHandlerReifier(T definition) {
        this.definition = definition;
    }

    public static void registerReifier(Class<?> errorHandlerClass, Function<ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> creator) {
        ERROR_HANDLERS.put(errorHandlerClass, creator);
    }

    public static ErrorHandlerReifier<? extends ErrorHandlerFactory> reifier(ErrorHandlerFactory definition) {
        Function<ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> reifier = ERROR_HANDLERS.get(definition.getClass());
        if (reifier != null) {
            return reifier.apply(definition);
        }
        if (definition instanceof ErrorHandlerBuilderSupport) {
            return new ErrorHandlerReifier<ErrorHandlerBuilderSupport>((ErrorHandlerBuilderSupport)definition){

                @Override
                public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
                    return this.definition.createErrorHandler(routeContext, processor);
                }
            };
        }
        throw new IllegalStateException("Unsupported definition: " + definition);
    }

    public static ExceptionPolicy createExceptionPolicy(OnExceptionDefinition def, RouteContext routeContext) {
        return new ExceptionPolicy(def.getId(), CamelContextHelper.getRouteId((NamedNode)def), def.getUseOriginalMessagePolicy() != null && def.getUseOriginalMessagePolicy() != false, ObjectHelper.isNotEmpty(def.getOutputs()), def.getHandledPolicy(), def.getContinuedPolicy(), def.getRetryWhilePolicy(), def.getOnRedelivery(), def.getOnExceptionOccurred(), def.getRedeliveryPolicyRef(), ErrorHandlerReifier.getRedeliveryPolicy(def.getRedeliveryPolicyType()), def.getExceptions());
    }

    private static Map<ExceptionPolicy.RedeliveryOption, String> getRedeliveryPolicy(RedeliveryPolicyDefinition definition) {
        if (definition == null) {
            return null;
        }
        HashMap<ExceptionPolicy.RedeliveryOption, String> policy = new HashMap<ExceptionPolicy.RedeliveryOption, String>();
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveries, definition.getMaximumRedeliveries());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.redeliveryDelay, definition.getRedeliveryDelay());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.asyncDelayedRedelivery, definition.getAsyncDelayedRedelivery());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.backOffMultiplier, definition.getBackOffMultiplier());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.useExponentialBackOff, definition.getUseExponentialBackOff());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.collisionAvoidanceFactor, definition.getCollisionAvoidanceFactor());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.useCollisionAvoidance, definition.getUseCollisionAvoidance());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveryDelay, definition.getMaximumRedeliveryDelay());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.retriesExhaustedLogLevel, definition.getRetriesExhaustedLogLevel());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogLevel, definition.getRetryAttemptedLogLevel());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogInterval, definition.getRetryAttemptedLogInterval());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.logRetryAttempted, definition.getLogRetryAttempted());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.logStackTrace, definition.getLogStackTrace());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.logRetryStackTrace, definition.getLogRetryStackTrace());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.logHandled, definition.getLogHandled());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.logNewException, definition.getLogNewException());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.logContinued, definition.getLogContinued());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.logExhausted, definition.getLogExhausted());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageHistory, definition.getLogExhaustedMessageHistory());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageBody, definition.getLogExhaustedMessageBody());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.disableRedelivery, definition.getDisableRedelivery());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.delayPattern, definition.getDelayPattern());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.allowRedeliveryWhileStopping, definition.getAllowRedeliveryWhileStopping());
        ErrorHandlerReifier.setoption(policy, ExceptionPolicy.RedeliveryOption.exchangeFormatterRef, definition.getExchangeFormatterRef());
        return policy;
    }

    private static void setoption(Map<ExceptionPolicy.RedeliveryOption, String> policy, ExceptionPolicy.RedeliveryOption option, Object value) {
        if (value != null) {
            policy.put(option, value.toString());
        }
    }

    public static ErrorHandlerFactory lookupErrorHandlerFactory(RouteContext routeContext, String ref) {
        return ErrorHandlerReifier.lookupErrorHandlerFactory(routeContext, ref, true);
    }

    public static ErrorHandlerFactory lookupErrorHandlerFactory(RouteContext routeContext, String ref, boolean mandatory) {
        ErrorHandlerFactory answer;
        if (!ErrorHandlerReifier.isErrorHandlerFactoryConfigured(ref)) {
            RouteDefinition route = (RouteDefinition)routeContext.getRoute();
            answer = route.getErrorHandlerFactory();
            if (answer == null && route.getErrorHandlerRef() != null) {
                answer = (ErrorHandlerFactory)routeContext.lookup(route.getErrorHandlerRef(), ErrorHandlerBuilder.class);
            }
            if (answer == null) {
                answer = new DefaultErrorHandlerBuilder();
            }
            if (answer instanceof ErrorHandlerBuilderRef) {
                ErrorHandlerBuilderRef other = (ErrorHandlerBuilderRef)answer;
                String otherRef = other.getRef();
                if (!ErrorHandlerReifier.isErrorHandlerFactoryConfigured(otherRef)) {
                    answer = ErrorHandlerReifier.lookupErrorHandlerFactory(routeContext.getCamelContext());
                }
                if (answer == null) {
                    answer = new DefaultErrorHandlerBuilder();
                }
                routeContext.addErrorHandlerFactoryReference((ErrorHandlerFactory)other, answer);
            }
        } else {
            answer = mandatory ? (ErrorHandlerFactory)routeContext.mandatoryLookup(ref, ErrorHandlerBuilder.class) : (ErrorHandlerFactory)routeContext.lookup(ref, ErrorHandlerBuilder.class);
        }
        return answer;
    }

    protected static ErrorHandlerFactory lookupErrorHandlerFactory(CamelContext camelContext) {
        ErrorHandlerBuilderRef other;
        String otherRef;
        ErrorHandlerFactory answer = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getErrorHandlerFactory();
        if (answer instanceof ErrorHandlerBuilderRef && ErrorHandlerReifier.isErrorHandlerFactoryConfigured(otherRef = (other = (ErrorHandlerBuilderRef)answer).getRef()) && (answer = (ErrorHandlerFactory)camelContext.getRegistry().lookupByNameAndType(otherRef, ErrorHandlerBuilder.class)) == null) {
            throw new IllegalArgumentException("ErrorHandlerBuilder with id " + otherRef + " not found in registry.");
        }
        return answer;
    }

    public static boolean isErrorHandlerFactoryConfigured(String ref) {
        return !DEFAULT_ERROR_HANDLER_BUILDER.equals(ref);
    }

    public abstract Processor createErrorHandler(RouteContext var1, Processor var2) throws Exception;

    public void configure(RouteContext routeContext, ErrorHandler handler) {
        boolean original;
        if (handler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport handlerSupport = (ErrorHandlerSupport)handler;
            for (NamedNode exception : routeContext.getErrorHandlers(this.definition)) {
                ErrorHandlerBuilderSupport.addExceptionPolicy(handlerSupport, routeContext, (OnExceptionDefinition)exception);
            }
        }
        if (handler instanceof RedeliveryErrorHandler && (original = ((RedeliveryErrorHandler)handler).isUseOriginalMessagePolicy())) {
            routeContext.setAllowUseOriginalMessage(Boolean.valueOf(true));
        }
    }

    public static RedeliveryPolicy createRedeliveryPolicy(RedeliveryPolicyDefinition definition, CamelContext context, RedeliveryPolicy parentPolicy) {
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        try {
            if (definition.getMaximumRedeliveries() != null) {
                answer.setMaximumRedeliveries(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getMaximumRedeliveries()).intValue());
            }
            if (definition.getRedeliveryDelay() != null) {
                answer.setRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)definition.getRedeliveryDelay()).longValue());
            }
            if (definition.getAsyncDelayedRedelivery() != null) {
                answer.setAsyncDelayedRedelivery(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAsyncDelayedRedelivery()).booleanValue());
            }
            if (definition.getRetriesExhaustedLogLevel() != null) {
                answer.setRetriesExhaustedLogLevel(definition.getRetriesExhaustedLogLevel());
            }
            if (definition.getRetryAttemptedLogLevel() != null) {
                answer.setRetryAttemptedLogLevel(definition.getRetryAttemptedLogLevel());
            }
            if (definition.getRetryAttemptedLogInterval() != null) {
                answer.setRetryAttemptedLogInterval(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getRetryAttemptedLogInterval()).intValue());
            }
            if (definition.getBackOffMultiplier() != null) {
                answer.setBackOffMultiplier(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.getBackOffMultiplier()).doubleValue());
            }
            if (definition.getUseExponentialBackOff() != null) {
                answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getUseExponentialBackOff()).booleanValue());
            }
            if (definition.getCollisionAvoidanceFactor() != null) {
                answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.getCollisionAvoidanceFactor()).doubleValue());
            }
            if (definition.getUseCollisionAvoidance() != null) {
                answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getUseCollisionAvoidance()).booleanValue());
            }
            if (definition.getMaximumRedeliveryDelay() != null) {
                answer.setMaximumRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)definition.getMaximumRedeliveryDelay()).longValue());
            }
            if (definition.getLogStackTrace() != null) {
                answer.setLogStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogStackTrace()).booleanValue());
            }
            if (definition.getLogRetryStackTrace() != null) {
                answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogRetryStackTrace()).booleanValue());
            }
            if (definition.getLogHandled() != null) {
                answer.setLogHandled(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogHandled()).booleanValue());
            }
            if (definition.getLogNewException() != null) {
                answer.setLogNewException(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogNewException()).booleanValue());
            }
            if (definition.getLogContinued() != null) {
                answer.setLogContinued(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogContinued()).booleanValue());
            }
            if (definition.getLogRetryAttempted() != null) {
                answer.setLogRetryAttempted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogRetryAttempted()).booleanValue());
            }
            if (definition.getLogExhausted() != null) {
                answer.setLogExhausted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhausted()).booleanValue());
            }
            if (definition.getLogExhaustedMessageHistory() != null) {
                answer.setLogExhaustedMessageHistory(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhaustedMessageHistory()).booleanValue());
            }
            if (definition.getLogExhaustedMessageBody() != null) {
                answer.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhaustedMessageBody()));
            }
            if (definition.getDisableRedelivery() != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getDisableRedelivery()).booleanValue()) {
                answer.setMaximumRedeliveries(0);
            }
            if (definition.getDelayPattern() != null) {
                answer.setDelayPattern(CamelContextHelper.parseText((CamelContext)context, (String)definition.getDelayPattern()));
            }
            if (definition.getAllowRedeliveryWhileStopping() != null) {
                answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAllowRedeliveryWhileStopping()).booleanValue());
            }
            if (definition.getExchangeFormatterRef() != null) {
                answer.setExchangeFormatterRef(CamelContextHelper.parseText((CamelContext)context, (String)definition.getExchangeFormatterRef()));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    static {
        HashMap map = new HashMap();
        map.put(DeadLetterChannelBuilder.class, DeadLetterChannelReifier::new);
        map.put(DefaultErrorHandlerBuilder.class, DefaultErrorHandlerReifier::new);
        map.put(ErrorHandlerBuilderRef.class, ErrorHandlerRefReifier::new);
        map.put(NoErrorHandlerBuilder.class, NoErrorHandlerReifier::new);
        ERROR_HANDLERS = map;
    }
}

