/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.BindyDataFormat;
import org.apache.camel.model.dataformat.BindyType;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.spi.DataFormat;

public class BindyDataFormatReifier
extends DataFormatReifier<BindyDataFormat> {
    public BindyDataFormatReifier(DataFormatDefinition definition) {
        super((BindyDataFormat)definition);
    }

    @Override
    protected DataFormat doCreateDataFormat(CamelContext camelContext) {
        if (((BindyDataFormat)this.definition).getClassTypeAsString() == null && ((BindyDataFormat)this.definition).getClassType() == null) {
            throw new IllegalArgumentException("Either packages or classType must be specified");
        }
        if (((BindyDataFormat)this.definition).getType() == BindyType.Csv) {
            ((BindyDataFormat)this.definition).setDataFormatName("bindy-csv");
        } else if (((BindyDataFormat)this.definition).getType() == BindyType.Fixed) {
            ((BindyDataFormat)this.definition).setDataFormatName("bindy-fixed");
        } else {
            ((BindyDataFormat)this.definition).setDataFormatName("bindy-kvp");
        }
        if (((BindyDataFormat)this.definition).getClassType() == null && ((BindyDataFormat)this.definition).getClassTypeAsString() != null) {
            try {
                ((BindyDataFormat)this.definition).setClassType(camelContext.getClassResolver().resolveMandatoryClass(((BindyDataFormat)this.definition).getClassTypeAsString()));
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return super.doCreateDataFormat(camelContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        this.setProperty(camelContext, dataFormat, "locale", ((BindyDataFormat)this.definition).getLocale());
        this.setProperty(camelContext, dataFormat, "classType", ((BindyDataFormat)this.definition).getClassType());
        if (((BindyDataFormat)this.definition).getUnwrapSingleInstance() != null) {
            this.setProperty(camelContext, dataFormat, "unwrapSingleInstance", ((BindyDataFormat)this.definition).getUnwrapSingleInstance());
        }
    }
}

