/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.reifier.ToDynamicReifier;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;

class WireTapReifier
extends ToDynamicReifier<WireTapDefinition<?>> {
    WireTapReifier(ProcessorDefinition<?> definition) {
        super(definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, (ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "WireTap", (ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ((WireTapDefinition)this.definition).setPattern(ExchangePattern.InOnly);
        SendDynamicProcessor dynamicTo = (SendDynamicProcessor)super.createProcessor(routeContext);
        Processor target = this.wrapInErrorHandler(routeContext, (Processor)dynamicTo);
        CamelInternalProcessor internal = new CamelInternalProcessor(target);
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.UnitOfWorkProcessorAdvice(routeContext));
        boolean isCopy = ((WireTapDefinition)this.definition).getCopy() == null || ((WireTapDefinition)this.definition).getCopy() != false;
        WireTapProcessor answer = new WireTapProcessor(dynamicTo, (Processor)internal, ((WireTapDefinition)this.definition).getPattern(), threadPool, shutdownThreadPool, ((WireTapDefinition)this.definition).isDynamic());
        answer.setCopy(isCopy);
        if (((WireTapDefinition)this.definition).getNewExchangeProcessorRef() != null) {
            ((WireTapDefinition)this.definition).setNewExchangeProcessor((Processor)routeContext.mandatoryLookup(((WireTapDefinition)this.definition).getNewExchangeProcessorRef(), Processor.class));
        }
        if (((WireTapDefinition)this.definition).getNewExchangeProcessor() != null) {
            answer.addNewExchangeProcessor(((WireTapDefinition)this.definition).getNewExchangeProcessor());
        }
        if (((WireTapDefinition)this.definition).getNewExchangeExpression() != null) {
            answer.setNewExchangeExpression(((WireTapDefinition)this.definition).getNewExchangeExpression().createExpression(routeContext));
        }
        if (((WireTapDefinition)this.definition).getHeaders() != null && !((WireTapDefinition)this.definition).getHeaders().isEmpty()) {
            for (SetHeaderDefinition header : ((WireTapDefinition)this.definition).getHeaders()) {
                Processor processor = this.createProcessor(routeContext, header);
                answer.addNewExchangeProcessor(processor);
            }
        }
        if (((WireTapDefinition)this.definition).getOnPrepareRef() != null) {
            ((WireTapDefinition)this.definition).setOnPrepare((Processor)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)((WireTapDefinition)this.definition).getOnPrepareRef(), Processor.class));
        }
        if (((WireTapDefinition)this.definition).getOnPrepare() != null) {
            answer.setOnPrepare(((WireTapDefinition)this.definition).getOnPrepare());
        }
        return answer;
    }

    @Override
    protected Expression createExpression(RouteContext routeContext) {
        if (((WireTapDefinition)this.definition).isDynamic()) {
            return super.createExpression(routeContext);
        }
        return ExpressionBuilder.constantExpression((Object)((WireTapDefinition)this.definition).getUri());
    }
}

