/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import org.apache.camel.Processor;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.TryProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;

class TryReifier
extends ProcessorReifier<TryDefinition> {
    TryReifier(ProcessorDefinition<?> definition) {
        super((TryDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        FinallyDefinition finallyDefinition;
        Processor tryProcessor = this.createOutputsProcessor(routeContext, ((TryDefinition)this.definition).getOutputsWithoutCatches());
        if (tryProcessor == null) {
            throw new IllegalArgumentException("Definition has no children on " + this);
        }
        ArrayList<Processor> catchProcessors = new ArrayList<Processor>();
        if (((TryDefinition)this.definition).getCatchClauses() != null) {
            for (CatchDefinition catchClause : ((TryDefinition)this.definition).getCatchClauses()) {
                catchProcessors.add(this.createProcessor(routeContext, catchClause));
            }
        }
        if ((finallyDefinition = ((TryDefinition)this.definition).getFinallyClause()) == null) {
            finallyDefinition = new FinallyDefinition();
            finallyDefinition.setParent(this.definition);
        }
        Processor finallyProcessor = this.createProcessor(routeContext, finallyDefinition);
        if (((TryDefinition)this.definition).getFinallyClause() == null && ((TryDefinition)this.definition).getCatchClauses() == null) {
            throw new IllegalArgumentException("doTry must have one or more catch or finally blocks on " + this);
        }
        return new TryProcessor(tryProcessor, catchProcessors, finallyProcessor);
    }
}

