/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

class ToDynamicReifier<T extends ToDynamicDefinition>
extends ProcessorReifier<T> {
    ToDynamicReifier(ProcessorDefinition<?> definition) {
        super((ToDynamicDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        StringHelper.notEmpty((String)((ToDynamicDefinition)this.definition).getUri(), (String)"uri", (Object)this);
        Expression exp = this.createExpression(routeContext);
        SendDynamicProcessor processor = new SendDynamicProcessor(((ToDynamicDefinition)this.definition).getUri(), exp);
        processor.setCamelContext(routeContext.getCamelContext());
        processor.setPattern(((ToDynamicDefinition)this.definition).getPattern());
        if (((ToDynamicDefinition)this.definition).getCacheSize() != null) {
            processor.setCacheSize(((ToDynamicDefinition)this.definition).getCacheSize().intValue());
        }
        if (((ToDynamicDefinition)this.definition).getIgnoreInvalidEndpoint() != null) {
            processor.setIgnoreInvalidEndpoint(((ToDynamicDefinition)this.definition).getIgnoreInvalidEndpoint().booleanValue());
        }
        return processor;
    }

    protected Expression createExpression(RouteContext routeContext) {
        String[] parts;
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (String part : parts = ToDynamicReifier.safeSplitRaw(((ToDynamicDefinition)this.definition).getUri())) {
            String value = StringHelper.after((String)part, (String)"language:");
            if (value != null) {
                String before = StringHelper.before((String)value, (String)":");
                String after = StringHelper.after((String)value, (String)":");
                if (before != null && after != null) {
                    try {
                        Language partLanguage = routeContext.getCamelContext().resolveLanguage(before);
                        if (partLanguage != null) {
                            Expression exp = partLanguage.createExpression(after);
                            list.add(exp);
                            continue;
                        }
                    }
                    catch (NoSuchLanguageException noSuchLanguageException) {
                        // empty catch block
                    }
                }
            }
            Language lan = routeContext.getCamelContext().resolveLanguage("simple");
            Expression exp = lan.createExpression(part);
            list.add(exp);
        }
        Expression exp = list.size() == 1 ? (Expression)list.get(0) : ExpressionBuilder.concatExpression(list);
        return exp;
    }

    private static String[] safeSplitRaw(String s) {
        ArrayList<String> list = new ArrayList<String>();
        if (!s.contains("+")) {
            list.add(s);
        } else {
            List rawPairs = URISupport.scanRaw((String)s);
            StringBuilder sb = new StringBuilder();
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (ch != '+' || URISupport.isRaw((int)i, (List)rawPairs)) {
                    sb.append(ch);
                    continue;
                }
                list.add(sb.toString());
                sb.setLength(0);
            }
            if (sb.length() > 0) {
                list.add(sb.toString());
                sb.setLength(0);
            }
        }
        return list.toArray(new String[list.size()]);
    }
}

