/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.Throttler;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.spi.RouteContext;

class ThrottleReifier
extends ExpressionReifier<ThrottleDefinition> {
    ThrottleReifier(ProcessorDefinition<?> definition) {
        super((ThrottleDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        boolean async = ((ThrottleDefinition)this.definition).getAsyncDelayed() != null && ((ThrottleDefinition)this.definition).getAsyncDelayed() != false;
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, (ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ScheduledExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredScheduledExecutorService(routeContext, "Throttle", (ExecutorServiceAwareDefinition)((Object)this.definition), true);
        long period = ((ThrottleDefinition)this.definition).getTimePeriodMillis() != null ? ((ThrottleDefinition)this.definition).getTimePeriodMillis() : 1000L;
        Expression maxRequestsExpression = this.createMaxRequestsPerPeriodExpression(routeContext);
        if (maxRequestsExpression == null) {
            throw new IllegalArgumentException("MaxRequestsPerPeriod expression must be provided on " + this);
        }
        Expression correlation = null;
        if (((ThrottleDefinition)this.definition).getCorrelationExpression() != null) {
            correlation = ((ThrottleDefinition)this.definition).getCorrelationExpression().createExpression(routeContext);
        }
        boolean reject = ((ThrottleDefinition)this.definition).getRejectExecution() != null && ((ThrottleDefinition)this.definition).getRejectExecution() != false;
        Throttler answer = new Throttler(routeContext.getCamelContext(), maxRequestsExpression, period, threadPool, shutdownThreadPool, reject, correlation);
        answer.setAsyncDelayed(async);
        if (((ThrottleDefinition)this.definition).getCallerRunsWhenRejected() == null) {
            answer.setCallerRunsWhenRejected(true);
        } else {
            answer.setCallerRunsWhenRejected(((ThrottleDefinition)this.definition).getCallerRunsWhenRejected().booleanValue());
        }
        return answer;
    }

    private Expression createMaxRequestsPerPeriodExpression(RouteContext routeContext) {
        ExpressionDefinition expr = ((ThrottleDefinition)this.definition).getExpression();
        if (expr != null) {
            return expr.createExpression(routeContext);
        }
        return null;
    }
}

