/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.Splitter;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;

class SplitReifier
extends ExpressionReifier<SplitDefinition> {
    SplitReifier(ProcessorDefinition<?> definition) {
        super((SplitDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        long timeout;
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        ((SplitDefinition)this.definition).setAggregationStrategy(this.createAggregationStrategy(routeContext));
        boolean isParallelProcessing = ((SplitDefinition)this.definition).getParallelProcessing() != null && ((SplitDefinition)this.definition).getParallelProcessing() != false;
        boolean isStreaming = ((SplitDefinition)this.definition).getStreaming() != null && ((SplitDefinition)this.definition).getStreaming() != false;
        boolean isShareUnitOfWork = ((SplitDefinition)this.definition).getShareUnitOfWork() != null && ((SplitDefinition)this.definition).getShareUnitOfWork() != false;
        boolean isParallelAggregate = ((SplitDefinition)this.definition).getParallelAggregate() != null && ((SplitDefinition)this.definition).getParallelAggregate() != false;
        boolean isStopOnAggregateException = ((SplitDefinition)this.definition).getStopOnAggregateException() != null && ((SplitDefinition)this.definition).getStopOnAggregateException() != false;
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "Split", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        long l = timeout = ((SplitDefinition)this.definition).getTimeout() != null ? ((SplitDefinition)this.definition).getTimeout() : 0L;
        if (timeout > 0L && !isParallelProcessing) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        if (((SplitDefinition)this.definition).getOnPrepareRef() != null) {
            ((SplitDefinition)this.definition).setOnPrepare((Processor)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)((SplitDefinition)this.definition).getOnPrepareRef(), Processor.class));
        }
        Expression exp = ((SplitDefinition)this.definition).getExpression().createExpression(routeContext);
        Splitter answer = new Splitter(routeContext.getCamelContext(), exp, childProcessor, ((SplitDefinition)this.definition).getAggregationStrategy(), isParallelProcessing, threadPool, shutdownThreadPool, isStreaming, ((SplitDefinition)this.definition).isStopOnException().booleanValue(), timeout, ((SplitDefinition)this.definition).getOnPrepare(), isShareUnitOfWork, isParallelAggregate, isStopOnAggregateException);
        return answer;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = ((SplitDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((SplitDefinition)this.definition).getStrategyRef() != null) {
            Object aggStrategy = routeContext.lookup(((SplitDefinition)this.definition).getStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((SplitDefinition)this.definition).getStrategyMethodName());
                if (((SplitDefinition)this.definition).getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(((SplitDefinition)this.definition).getStrategyMethodAllowNull().booleanValue());
                    adapter.setAllowNullOldExchange(((SplitDefinition)this.definition).getStrategyMethodAllowNull().booleanValue());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((SplitDefinition)this.definition).getStrategyRef());
            }
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(routeContext.getCamelContext());
        }
        if (strategy != null && ((SplitDefinition)this.definition).getShareUnitOfWork() != null && ((SplitDefinition)this.definition).getShareUnitOfWork().booleanValue()) {
            strategy = new ShareUnitOfWorkAggregationStrategy(strategy);
        }
        return strategy;
    }
}

