/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.processor.EvaluateExpressionProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;

class RecipientListReifier
extends ProcessorReifier<RecipientListDefinition<?>> {
    RecipientListReifier(ProcessorDefinition<?> definition) {
        super((RecipientListDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        long timeout;
        final Expression expression = ((RecipientListDefinition)this.definition).getExpression().createExpression(routeContext);
        boolean isParallelProcessing = ((RecipientListDefinition)this.definition).getParallelProcessing() != null && ((RecipientListDefinition)this.definition).getParallelProcessing() != false;
        boolean isStreaming = ((RecipientListDefinition)this.definition).getStreaming() != null && ((RecipientListDefinition)this.definition).getStreaming() != false;
        boolean isParallelAggregate = ((RecipientListDefinition)this.definition).getParallelAggregate() != null && ((RecipientListDefinition)this.definition).getParallelAggregate() != false;
        boolean isShareUnitOfWork = ((RecipientListDefinition)this.definition).getShareUnitOfWork() != null && ((RecipientListDefinition)this.definition).getShareUnitOfWork() != false;
        boolean isStopOnException = ((RecipientListDefinition)this.definition).getStopOnException() != null && ((RecipientListDefinition)this.definition).getStopOnException() != false;
        boolean isIgnoreInvalidEndpoints = ((RecipientListDefinition)this.definition).getIgnoreInvalidEndpoints() != null && ((RecipientListDefinition)this.definition).getIgnoreInvalidEndpoints() != false;
        boolean isStopOnAggregateException = ((RecipientListDefinition)this.definition).getStopOnAggregateException() != null && ((RecipientListDefinition)this.definition).getStopOnAggregateException() != false;
        RecipientList answer = ((RecipientListDefinition)this.definition).getDelimiter() != null ? new RecipientList(routeContext.getCamelContext(), expression, ((RecipientListDefinition)this.definition).getDelimiter()) : new RecipientList(routeContext.getCamelContext(), expression);
        answer.setAggregationStrategy(this.createAggregationStrategy(routeContext));
        answer.setParallelProcessing(isParallelProcessing);
        answer.setParallelAggregate(isParallelAggregate);
        answer.setStreaming(isStreaming);
        answer.setShareUnitOfWork(isShareUnitOfWork);
        answer.setStopOnException(isStopOnException);
        answer.setIgnoreInvalidEndpoints(isIgnoreInvalidEndpoints);
        answer.setStopOnAggregateException(isStopOnAggregateException);
        if (((RecipientListDefinition)this.definition).getCacheSize() != null) {
            answer.setCacheSize(((RecipientListDefinition)this.definition).getCacheSize().intValue());
        }
        if (((RecipientListDefinition)this.definition).getOnPrepareRef() != null) {
            ((RecipientListDefinition)this.definition).setOnPrepare((Processor)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)((RecipientListDefinition)this.definition).getOnPrepareRef(), Processor.class));
        }
        if (((RecipientListDefinition)this.definition).getOnPrepare() != null) {
            answer.setOnPrepare(((RecipientListDefinition)this.definition).getOnPrepare());
        }
        if (((RecipientListDefinition)this.definition).getTimeout() != null) {
            answer.setTimeout(((RecipientListDefinition)this.definition).getTimeout().longValue());
        }
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "RecipientList", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        answer.setExecutorService(threadPool);
        answer.setShutdownExecutorService(shutdownThreadPool);
        long l = timeout = ((RecipientListDefinition)this.definition).getTimeout() != null ? ((RecipientListDefinition)this.definition).getTimeout() : 0L;
        if (timeout > 0L && !isParallelProcessing) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        ArrayList<Object> pipe = new ArrayList<Object>(2);
        EvaluateExpressionProcessor evalProcessor = new EvaluateExpressionProcessor(expression);
        evalProcessor = super.wrapInErrorHandler(routeContext, (Processor)evalProcessor);
        pipe.add(evalProcessor);
        pipe.add(answer);
        return new Pipeline(routeContext.getCamelContext(), pipe){

            public String toString() {
                return "RecipientList[" + expression + "]";
            }
        };
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = ((RecipientListDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((RecipientListDefinition)this.definition).getStrategyRef() != null) {
            Object aggStrategy = routeContext.lookup(((RecipientListDefinition)this.definition).getStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((RecipientListDefinition)this.definition).getStrategyMethodName());
                if (((RecipientListDefinition)this.definition).getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(((RecipientListDefinition)this.definition).getStrategyMethodAllowNull().booleanValue());
                    adapter.setAllowNullOldExchange(((RecipientListDefinition)this.definition).getStrategyMethodAllowNull().booleanValue());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((RecipientListDefinition)this.definition).getStrategyRef());
            }
        }
        if (strategy == null) {
            strategy = new UseLatestAggregationStrategy();
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(routeContext.getCamelContext());
        }
        if (((RecipientListDefinition)this.definition).getShareUnitOfWork() != null && ((RecipientListDefinition)this.definition).getShareUnitOfWork().booleanValue()) {
            strategy = new ShareUnitOfWorkAggregationStrategy(strategy);
        }
        return strategy;
    }
}

