/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Channel;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ClaimCheckDefinition;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.HystrixDefinition;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.InOnlyDefinition;
import org.apache.camel.model.InOutDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OnFallbackDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RemoveHeaderDefinition;
import org.apache.camel.model.RemoveHeadersDefinition;
import org.apache.camel.model.RemovePropertiesDefinition;
import org.apache.camel.model.RemovePropertyDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RollbackDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SamplingDefinition;
import org.apache.camel.model.ScriptDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetExchangePatternDefinition;
import org.apache.camel.model.SetFaultBodyDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.model.StopDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.model.ThrowExceptionDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.ValidateDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.WhenSkipSendToEndpointDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.InterceptEndpointProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.channel.DefaultChannel;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.reifier.AggregateReifier;
import org.apache.camel.reifier.BeanReifier;
import org.apache.camel.reifier.CatchReifier;
import org.apache.camel.reifier.ChoiceReifier;
import org.apache.camel.reifier.ClaimCheckReifier;
import org.apache.camel.reifier.ConvertBodyReifier;
import org.apache.camel.reifier.DelayReifier;
import org.apache.camel.reifier.DynamicRouterReifier;
import org.apache.camel.reifier.EnrichReifier;
import org.apache.camel.reifier.FilterReifier;
import org.apache.camel.reifier.FinallyReifier;
import org.apache.camel.reifier.HystrixReifier;
import org.apache.camel.reifier.IdempotentConsumerReifier;
import org.apache.camel.reifier.InterceptFromReifier;
import org.apache.camel.reifier.InterceptReifier;
import org.apache.camel.reifier.InterceptSendToEndpointReifier;
import org.apache.camel.reifier.LoadBalanceReifier;
import org.apache.camel.reifier.LogReifier;
import org.apache.camel.reifier.LoopReifier;
import org.apache.camel.reifier.MarshalReifier;
import org.apache.camel.reifier.MulticastReifier;
import org.apache.camel.reifier.OnCompletionReifier;
import org.apache.camel.reifier.OnExceptionReifier;
import org.apache.camel.reifier.OnFallbackReifier;
import org.apache.camel.reifier.OtherwiseReifier;
import org.apache.camel.reifier.PipelineReifier;
import org.apache.camel.reifier.PolicyReifier;
import org.apache.camel.reifier.PollEnrichReifier;
import org.apache.camel.reifier.ProcessReifier;
import org.apache.camel.reifier.RecipientListReifier;
import org.apache.camel.reifier.RemoveHeaderReifier;
import org.apache.camel.reifier.RemoveHeadersReifier;
import org.apache.camel.reifier.RemovePropertiesReifier;
import org.apache.camel.reifier.RemovePropertyReifier;
import org.apache.camel.reifier.ResequenceReifier;
import org.apache.camel.reifier.RollbackReifier;
import org.apache.camel.reifier.RouteReifier;
import org.apache.camel.reifier.RoutingSlipReifier;
import org.apache.camel.reifier.SagaReifier;
import org.apache.camel.reifier.SamplingReifier;
import org.apache.camel.reifier.ScriptReifier;
import org.apache.camel.reifier.SendReifier;
import org.apache.camel.reifier.ServiceCallReifier;
import org.apache.camel.reifier.SetBodyReifier;
import org.apache.camel.reifier.SetExchangePatternReifier;
import org.apache.camel.reifier.SetFaultBodyReifier;
import org.apache.camel.reifier.SetHeaderReifier;
import org.apache.camel.reifier.SetPropertyReifier;
import org.apache.camel.reifier.SortReifier;
import org.apache.camel.reifier.SplitReifier;
import org.apache.camel.reifier.StepReifier;
import org.apache.camel.reifier.StopReifier;
import org.apache.camel.reifier.ThreadsReifier;
import org.apache.camel.reifier.ThrottleReifier;
import org.apache.camel.reifier.ThrowExceptionReifier;
import org.apache.camel.reifier.ToDynamicReifier;
import org.apache.camel.reifier.TransactedReifier;
import org.apache.camel.reifier.TransformReifier;
import org.apache.camel.reifier.TryReifier;
import org.apache.camel.reifier.UnmarshalReifier;
import org.apache.camel.reifier.ValidateReifier;
import org.apache.camel.reifier.WhenReifier;
import org.apache.camel.reifier.WhenSkipSendToEndpointReifier;
import org.apache.camel.reifier.WireTapReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessorReifier<T extends ProcessorDefinition<?>> {
    private static final Map<Class<?>, Function<ProcessorDefinition<?>, ProcessorReifier<? extends ProcessorDefinition<?>>>> PROCESSORS;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final T definition;

    public ProcessorReifier(T definition) {
        this.definition = definition;
    }

    public static ProcessorReifier<? extends ProcessorDefinition<?>> reifier(ProcessorDefinition<?> definition) {
        Function<ProcessorDefinition<?>, ProcessorReifier<ProcessorDefinition<?>>> reifier = PROCESSORS.get(definition.getClass());
        if (reifier != null) {
            return reifier.apply(definition);
        }
        throw new IllegalStateException("Unsupported definition: " + definition);
    }

    public abstract Processor createProcessor(RouteContext var1) throws Exception;

    protected Processor createOutputsProcessor(RouteContext routeContext) throws Exception {
        List<ProcessorDefinition<?>> outputs = ((ProcessorDefinition)this.definition).getOutputs();
        return this.createOutputsProcessor(routeContext, outputs);
    }

    protected Processor createChildProcessor(RouteContext routeContext, boolean mandatory) throws Exception {
        Processor children = null;
        if (((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorFactory() != null) {
            children = ((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorFactory().createChildProcessor(routeContext, this.definition, mandatory);
        }
        if (children == null) {
            children = this.createOutputsProcessor(routeContext);
        }
        if (children == null && mandatory) {
            throw new IllegalArgumentException("Definition has no children on " + this.definition);
        }
        return children;
    }

    public void addRoutes(RouteContext routeContext) throws Exception {
        Channel processor = this.makeProcessor(routeContext);
        if (processor == null) {
            return;
        }
        if (!routeContext.isRouteAdded()) {
            boolean endpointInterceptor = processor.getNextProcessor() instanceof InterceptEndpointProcessor;
            if (endpointInterceptor) {
                this.log.debug("Endpoint interceptor should not be added as an event driven consumer route: {}", (Object)processor);
            } else {
                this.log.trace("Adding event driven processor: {}", (Object)processor);
                routeContext.addEventDrivenProcessor((Processor)processor);
            }
        }
    }

    public Channel wrapProcessor(RouteContext routeContext, Processor processor) throws Exception {
        if (processor instanceof Channel) {
            return (Channel)processor;
        }
        return this.wrapChannel(routeContext, processor, null);
    }

    protected Channel wrapChannel(RouteContext routeContext, Processor processor, ProcessorDefinition<?> child) throws Exception {
        return this.wrapChannel(routeContext, processor, child, ((ProcessorDefinition)this.definition).isInheritErrorHandler());
    }

    protected Channel wrapChannel(RouteContext routeContext, Processor processor, ProcessorDefinition<?> child, Boolean inheritErrorHandler) throws Exception {
        DefaultChannel channel = new DefaultChannel();
        ArrayList<InterceptStrategy> interceptors = new ArrayList<InterceptStrategy>();
        this.addInterceptStrategies(routeContext, interceptors, ((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getInterceptStrategies());
        this.addInterceptStrategies(routeContext, interceptors, routeContext.getInterceptStrategies());
        this.addInterceptStrategies(routeContext, interceptors, ((ProcessorDefinition)this.definition).getInterceptStrategies());
        RouteDefinitionHelper.forceAssignIds(routeContext.getCamelContext(), this.definition);
        if (child != null && this.definition != child) {
            child.setParent((ProcessorDefinition<?>)this.definition);
        }
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(this.definition);
        boolean first = false;
        if (route != null && !route.getOutputs().isEmpty()) {
            first = route.getOutputs().get(0) == this.definition;
        }
        boolean routeScoped = true;
        if (this.definition instanceof OnExceptionDefinition) {
            routeScoped = ((OnExceptionDefinition)this.definition).isRouteScoped();
        } else if (this.definition instanceof OnCompletionDefinition) {
            routeScoped = ((OnCompletionDefinition)this.definition).isRouteScoped();
        }
        channel.initChannel(routeContext, this.definition, child, interceptors, processor, (NamedNode)route, first, routeScoped);
        boolean wrap = false;
        if (this.definition instanceof TryDefinition || this.definition instanceof CatchDefinition || this.definition instanceof FinallyDefinition) {
            this.log.trace("{} is part of doTry .. doCatch .. doFinally so no error handler is applied", this.definition);
        } else if (ProcessorDefinitionHelper.isParentOfType(TryDefinition.class, this.definition, true) || ProcessorDefinitionHelper.isParentOfType(CatchDefinition.class, this.definition, true) || ProcessorDefinitionHelper.isParentOfType(FinallyDefinition.class, this.definition, true)) {
            this.log.trace("{} is part of doTry .. doCatch .. doFinally so no error handler is applied", this.definition);
        } else if (this.definition instanceof OnExceptionDefinition || ProcessorDefinitionHelper.isParentOfType(OnExceptionDefinition.class, this.definition, true)) {
            this.log.trace("{} is part of OnException so no error handler is applied", this.definition);
        } else if (this.definition instanceof HystrixDefinition || ProcessorDefinitionHelper.isParentOfType(HystrixDefinition.class, this.definition, true)) {
            if (inheritErrorHandler != null && inheritErrorHandler.booleanValue() && child == null) {
                wrap = true;
            } else {
                this.log.trace("{} is part of HystrixCircuitBreaker so no error handler is applied", this.definition);
            }
        } else if (this.definition instanceof MulticastDefinition) {
            boolean isShareUnitOfWork;
            MulticastDefinition def = (MulticastDefinition)this.definition;
            boolean bl = isShareUnitOfWork = def.getShareUnitOfWork() != null && def.getShareUnitOfWork() != false;
            if (isShareUnitOfWork && child == null) {
                wrap = true;
            } else {
                this.log.trace("{} is part of multicast which have special error handling so no error handler is applied", this.definition);
            }
        } else {
            wrap = true;
        }
        if (wrap) {
            this.wrapChannelInErrorHandler(channel, routeContext, inheritErrorHandler);
        }
        channel.postInitChannel();
        this.log.trace("{} wrapped in Channel: {}", this.definition, (Object)channel);
        return channel;
    }

    private void wrapChannelInErrorHandler(DefaultChannel channel, RouteContext routeContext, Boolean inheritErrorHandler) throws Exception {
        if (inheritErrorHandler == null || inheritErrorHandler.booleanValue()) {
            this.log.trace("{} is configured to inheritErrorHandler", this.definition);
            Processor output = channel.getOutput();
            Processor errorHandler = this.wrapInErrorHandler(routeContext, output);
            channel.setErrorHandler(errorHandler);
        } else {
            this.log.debug("{} is configured to not inheritErrorHandler.", this.definition);
        }
    }

    protected Processor wrapInErrorHandler(RouteContext routeContext, Processor output) throws Exception {
        ErrorHandlerFactory builder = routeContext.getErrorHandlerFactory();
        Processor errorHandler = ErrorHandlerReifier.reifier(builder).createErrorHandler(routeContext, output);
        for (LifecycleStrategy strategy : routeContext.getCamelContext().getLifecycleStrategies()) {
            strategy.onErrorHandlerAdd(routeContext, errorHandler, builder);
        }
        return errorHandler;
    }

    protected void addInterceptStrategies(RouteContext routeContext, List<InterceptStrategy> interceptors, List<InterceptStrategy> strategies) {
        for (InterceptStrategy strategy : strategies) {
            if (!routeContext.isHandleFault().booleanValue() && strategy instanceof HandleFault) continue;
            interceptors.add(strategy);
        }
    }

    protected Processor createCompositeProcessor(RouteContext routeContext, List<Processor> list) throws Exception {
        return Pipeline.newInstance((CamelContext)routeContext.getCamelContext(), list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Processor createOutputsProcessor(RouteContext routeContext, Collection<ProcessorDefinition<?>> outputs) throws Exception {
        Runnable propertyPlaceholdersChangeReverter = ProcessorDefinitionHelper.createPropertyPlaceholdersChangeReverter();
        try {
            Processor processor = this.createOutputsProcessorImpl(routeContext, outputs);
            return processor;
        }
        finally {
            propertyPlaceholdersChangeReverter.run();
        }
    }

    protected Processor createOutputsProcessorImpl(RouteContext routeContext, Collection<ProcessorDefinition<?>> outputs) throws Exception {
        ArrayList<Processor> list = new ArrayList<Processor>();
        for (ProcessorDefinition<?> output : outputs) {
            Processor processor;
            ExpressionNode exp;
            ExpressionDefinition expressionDefinition;
            ProcessorReifier.reifier(output).preCreateProcessor();
            ProcessorDefinitionHelper.resolvePropertyPlaceholders(routeContext.getCamelContext(), output);
            ProcessorDefinitionHelper.resolveKnownConstantFields(routeContext.getCamelContext(), output);
            ProcessorDefinition<?> me = output;
            if (me instanceof ExpressionNode && (expressionDefinition = (exp = (ExpressionNode)me).getExpression()) != null) {
                ProcessorDefinitionHelper.resolvePropertyPlaceholders(routeContext.getCamelContext(), expressionDefinition);
                ProcessorDefinitionHelper.resolveKnownConstantFields(routeContext.getCamelContext(), expressionDefinition);
            }
            if ((processor = this.createProcessor(routeContext, output)) instanceof IdAware) {
                String id = this.getId(output, routeContext);
                ((IdAware)processor).setId(id);
            }
            if (output instanceof Channel && processor == null) continue;
            Channel channel = this.wrapChannel(routeContext, processor, output);
            list.add((Processor)channel);
        }
        Processor processor = null;
        if (!list.isEmpty()) {
            processor = list.size() == 1 ? (Processor)list.get(0) : this.createCompositeProcessor(routeContext, list);
        }
        return processor;
    }

    protected Processor createProcessor(RouteContext routeContext, ProcessorDefinition<?> output) throws Exception {
        Processor processor = null;
        if (((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorFactory() != null) {
            processor = ((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorFactory().createProcessor(routeContext, output);
        }
        if (processor == null) {
            processor = ProcessorReifier.reifier(output).createProcessor(routeContext);
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Channel makeProcessor(RouteContext routeContext) throws Exception {
        Runnable propertyPlaceholdersChangeReverter = ProcessorDefinitionHelper.createPropertyPlaceholdersChangeReverter();
        try {
            Channel channel = this.makeProcessorImpl(routeContext);
            return channel;
        }
        finally {
            propertyPlaceholdersChangeReverter.run();
        }
    }

    private Channel makeProcessorImpl(RouteContext routeContext) throws Exception {
        ExpressionNode exp;
        ExpressionDefinition expressionDefinition;
        Processor processor = null;
        this.preCreateProcessor();
        ProcessorDefinitionHelper.resolvePropertyPlaceholders(routeContext.getCamelContext(), this.definition);
        ProcessorDefinitionHelper.resolveKnownConstantFields(routeContext.getCamelContext(), this.definition);
        T me = this.definition;
        if (me instanceof ExpressionNode && (expressionDefinition = (exp = (ExpressionNode)me).getExpression()) != null) {
            ProcessorDefinitionHelper.resolvePropertyPlaceholders(routeContext.getCamelContext(), expressionDefinition);
            ProcessorDefinitionHelper.resolveKnownConstantFields(routeContext.getCamelContext(), expressionDefinition);
        }
        if (((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorFactory() != null) {
            processor = ((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorFactory().createProcessor(routeContext, this.definition);
        }
        if (processor == null) {
            processor = this.createProcessor(routeContext);
        }
        if (processor instanceof IdAware) {
            String id = this.getId((OptionalIdentifiedDefinition<?>)this.definition, routeContext);
            ((IdAware)processor).setId(id);
        }
        if (processor == null) {
            return null;
        }
        return this.wrapProcessor(routeContext, processor);
    }

    protected void preCreateProcessor() {
        ((ProcessorDefinition)this.definition).preCreateProcessor();
    }

    public void configureChild(ProcessorDefinition<?> output) {
    }

    protected String getId(OptionalIdentifiedDefinition<?> def, RouteContext routeContext) {
        return def.idOrCreate(((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getNodeIdFactory());
    }

    static {
        HashMap map = new HashMap();
        map.put(AggregateDefinition.class, AggregateReifier::new);
        map.put(BeanDefinition.class, BeanReifier::new);
        map.put(CatchDefinition.class, CatchReifier::new);
        map.put(ChoiceDefinition.class, ChoiceReifier::new);
        map.put(ClaimCheckDefinition.class, ClaimCheckReifier::new);
        map.put(ConvertBodyDefinition.class, ConvertBodyReifier::new);
        map.put(DelayDefinition.class, DelayReifier::new);
        map.put(DynamicRouterDefinition.class, DynamicRouterReifier::new);
        map.put(EnrichDefinition.class, EnrichReifier::new);
        map.put(FilterDefinition.class, FilterReifier::new);
        map.put(FinallyDefinition.class, FinallyReifier::new);
        map.put(HystrixDefinition.class, HystrixReifier::new);
        map.put(IdempotentConsumerDefinition.class, IdempotentConsumerReifier::new);
        map.put(InOnlyDefinition.class, SendReifier::new);
        map.put(InOutDefinition.class, SendReifier::new);
        map.put(InterceptDefinition.class, InterceptReifier::new);
        map.put(InterceptFromDefinition.class, InterceptFromReifier::new);
        map.put(InterceptSendToEndpointDefinition.class, InterceptSendToEndpointReifier::new);
        map.put(LoadBalanceDefinition.class, LoadBalanceReifier::new);
        map.put(LogDefinition.class, LogReifier::new);
        map.put(LoopDefinition.class, LoopReifier::new);
        map.put(MarshalDefinition.class, MarshalReifier::new);
        map.put(MulticastDefinition.class, MulticastReifier::new);
        map.put(OnCompletionDefinition.class, OnCompletionReifier::new);
        map.put(OnExceptionDefinition.class, OnExceptionReifier::new);
        map.put(OnFallbackDefinition.class, OnFallbackReifier::new);
        map.put(OtherwiseDefinition.class, OtherwiseReifier::new);
        map.put(PipelineDefinition.class, PipelineReifier::new);
        map.put(PolicyDefinition.class, PolicyReifier::new);
        map.put(PollEnrichDefinition.class, PollEnrichReifier::new);
        map.put(ProcessDefinition.class, ProcessReifier::new);
        map.put(RecipientListDefinition.class, RecipientListReifier::new);
        map.put(RemoveHeaderDefinition.class, RemoveHeaderReifier::new);
        map.put(RemoveHeadersDefinition.class, RemoveHeadersReifier::new);
        map.put(RemovePropertiesDefinition.class, RemovePropertiesReifier::new);
        map.put(RemovePropertyDefinition.class, RemovePropertyReifier::new);
        map.put(ResequenceDefinition.class, ResequenceReifier::new);
        map.put(RollbackDefinition.class, RollbackReifier::new);
        map.put(RouteDefinition.class, RouteReifier::new);
        map.put(RoutingSlipDefinition.class, RoutingSlipReifier::new);
        map.put(SagaDefinition.class, SagaReifier::new);
        map.put(SamplingDefinition.class, SamplingReifier::new);
        map.put(ScriptDefinition.class, ScriptReifier::new);
        map.put(ServiceCallDefinition.class, ServiceCallReifier::new);
        map.put(SetBodyDefinition.class, SetBodyReifier::new);
        map.put(SetExchangePatternDefinition.class, SetExchangePatternReifier::new);
        map.put(SetFaultBodyDefinition.class, SetFaultBodyReifier::new);
        map.put(SetHeaderDefinition.class, SetHeaderReifier::new);
        map.put(SetPropertyDefinition.class, SetPropertyReifier::new);
        map.put(SortDefinition.class, SortReifier::new);
        map.put(SplitDefinition.class, SplitReifier::new);
        map.put(StepDefinition.class, StepReifier::new);
        map.put(StopDefinition.class, StopReifier::new);
        map.put(ThreadsDefinition.class, ThreadsReifier::new);
        map.put(ThrottleDefinition.class, ThrottleReifier::new);
        map.put(ThrowExceptionDefinition.class, ThrowExceptionReifier::new);
        map.put(ToDefinition.class, SendReifier::new);
        map.put(ToDynamicDefinition.class, ToDynamicReifier::new);
        map.put(TransactedDefinition.class, TransactedReifier::new);
        map.put(TransformDefinition.class, TransformReifier::new);
        map.put(TryDefinition.class, TryReifier::new);
        map.put(UnmarshalDefinition.class, UnmarshalReifier::new);
        map.put(ValidateDefinition.class, ValidateReifier::new);
        map.put(WireTapDefinition.class, WireTapReifier::new);
        map.put(WhenSkipSendToEndpointDefinition.class, WhenSkipSendToEndpointReifier::new);
        map.put(WhenDefinition.class, WhenReifier::new);
        PROCESSORS = map;
    }
}

