/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;

class PollEnrichReifier
extends ProcessorReifier<PollEnrichDefinition> {
    PollEnrichReifier(ProcessorDefinition<?> definition) {
        super((PollEnrichDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        long time = ((PollEnrichDefinition)this.definition).getTimeout() != null ? ((PollEnrichDefinition)this.definition).getTimeout() : -1L;
        boolean isIgnoreInvalidEndpoint = ((PollEnrichDefinition)this.definition).getIgnoreInvalidEndpoint() != null && ((PollEnrichDefinition)this.definition).getIgnoreInvalidEndpoint() != false;
        Expression exp = ((PollEnrichDefinition)this.definition).getExpression().createExpression(routeContext);
        PollEnricher enricher = new PollEnricher(exp, time);
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        if (strategy == null) {
            enricher.setDefaultAggregationStrategy();
        } else {
            enricher.setAggregationStrategy(strategy);
        }
        if (((PollEnrichDefinition)this.definition).getAggregateOnException() != null) {
            enricher.setAggregateOnException(((PollEnrichDefinition)this.definition).getAggregateOnException().booleanValue());
        }
        if (((PollEnrichDefinition)this.definition).getCacheSize() != null) {
            enricher.setCacheSize(((PollEnrichDefinition)this.definition).getCacheSize().intValue());
        }
        enricher.setIgnoreInvalidEndpoint(isIgnoreInvalidEndpoint);
        return enricher;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = ((PollEnrichDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((PollEnrichDefinition)this.definition).getAggregationStrategyRef() != null) {
            Object aggStrategy = routeContext.lookup(((PollEnrichDefinition)this.definition).getAggregationStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((PollEnrichDefinition)this.definition).getAggregationStrategyMethodName());
                if (((PollEnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(((PollEnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull().booleanValue());
                    adapter.setAllowNullOldExchange(((PollEnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull().booleanValue());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((PollEnrichDefinition)this.definition).getAggregationStrategyRef());
            }
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(routeContext.getCamelContext());
        }
        return strategy;
    }
}

