/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.reifier.TransactedReifier;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

class PolicyReifier
extends ProcessorReifier<PolicyDefinition> {
    PolicyReifier(ProcessorDefinition<?> definition) {
        super((PolicyDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Policy policy = this.resolvePolicy(routeContext);
        ObjectHelper.notNull((Object)policy, (String)"policy", (Object)this.definition);
        policy.beforeWrap(routeContext, (NamedNode)this.definition);
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        Processor target = policy.wrap(routeContext, childProcessor);
        if (!(target instanceof Service)) {
            target = new WrapProcessor(target, childProcessor);
        }
        return target;
    }

    protected Policy resolvePolicy(RouteContext routeContext) {
        if (((PolicyDefinition)this.definition).getPolicy() != null) {
            return ((PolicyDefinition)this.definition).getPolicy();
        }
        return TransactedReifier.resolvePolicy(routeContext, ((PolicyDefinition)this.definition).getRef(), ((PolicyDefinition)this.definition).getType());
    }
}

