/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OptimisticLockRetryPolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.SynchronousExecutorService;

class AggregateReifier
extends ProcessorReifier<AggregateDefinition> {
    AggregateReifier(ProcessorDefinition<?> definition) {
        super((ProcessorDefinition)AggregateDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return this.createAggregator(routeContext);
    }

    protected AggregateProcessor createAggregator(RouteContext routeContext) throws Exception {
        Expression expression;
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        CamelInternalProcessor internal = new CamelInternalProcessor(childProcessor);
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.UnitOfWorkProcessorAdvice(routeContext));
        Expression correlation = ((AggregateDefinition)this.definition).getExpression().createExpression(routeContext);
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        boolean parallel = ((AggregateDefinition)this.definition).getParallelProcessing() != null && ((AggregateDefinition)this.definition).getParallelProcessing() != false;
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, (ExecutorServiceAwareDefinition)((Object)this.definition), parallel);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "Aggregator", (ExecutorServiceAwareDefinition)((Object)this.definition), parallel);
        if (threadPool == null && !parallel) {
            threadPool = new SynchronousExecutorService();
            shutdownThreadPool = true;
        }
        AggregateProcessor answer = new AggregateProcessor(routeContext.getCamelContext(), (AsyncProcessor)internal, correlation, strategy, threadPool, shutdownThreadPool);
        AggregationRepository repository = this.createAggregationRepository(routeContext);
        if (repository != null) {
            answer.setAggregationRepository(repository);
        }
        if (((AggregateDefinition)this.definition).getAggregateController() == null && ((AggregateDefinition)this.definition).getAggregateControllerRef() != null) {
            ((AggregateDefinition)this.definition).setAggregateController((AggregateController)routeContext.mandatoryLookup(((AggregateDefinition)this.definition).getAggregateControllerRef(), AggregateController.class));
        }
        boolean shutdownTimeoutThreadPool = false;
        ScheduledExecutorService timeoutThreadPool = ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorService();
        if (timeoutThreadPool == null && ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorServiceRef() != null && (timeoutThreadPool = (ScheduledExecutorService)routeContext.lookup(((AggregateDefinition)this.definition).getTimeoutCheckerExecutorServiceRef(), ScheduledExecutorService.class)) == null) {
            timeoutThreadPool = routeContext.getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this, "AggregateTimeoutChecker", ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorServiceRef());
            if (timeoutThreadPool == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorServiceRef() + " not found in registry (as an ScheduledExecutorService instance) or as a thread pool profile.");
            }
            shutdownTimeoutThreadPool = true;
        }
        answer.setTimeoutCheckerExecutorService(timeoutThreadPool);
        answer.setShutdownTimeoutCheckerExecutorService(shutdownTimeoutThreadPool);
        answer.setParallelProcessing(parallel);
        if (((AggregateDefinition)this.definition).getOptimisticLocking() != null) {
            answer.setOptimisticLocking(((AggregateDefinition)this.definition).getOptimisticLocking().booleanValue());
        }
        if (((AggregateDefinition)this.definition).getCompletionPredicate() != null) {
            Predicate predicate = ((AggregateDefinition)this.definition).getCompletionPredicate().createPredicate(routeContext);
            answer.setCompletionPredicate(predicate);
        } else if (strategy instanceof Predicate) {
            this.log.debug("Using AggregationStrategy as completion predicate: {}", (Object)strategy);
            answer.setCompletionPredicate((Predicate)strategy);
        }
        if (((AggregateDefinition)this.definition).getCompletionTimeoutExpression() != null) {
            expression = ((AggregateDefinition)this.definition).getCompletionTimeoutExpression().createExpression(routeContext);
            answer.setCompletionTimeoutExpression(expression);
        }
        if (((AggregateDefinition)this.definition).getCompletionTimeout() != null) {
            answer.setCompletionTimeout(((AggregateDefinition)this.definition).getCompletionTimeout().longValue());
        }
        if (((AggregateDefinition)this.definition).getCompletionInterval() != null) {
            answer.setCompletionInterval(((AggregateDefinition)this.definition).getCompletionInterval().longValue());
        }
        if (((AggregateDefinition)this.definition).getCompletionSizeExpression() != null) {
            expression = ((AggregateDefinition)this.definition).getCompletionSizeExpression().createExpression(routeContext);
            answer.setCompletionSizeExpression(expression);
        }
        if (((AggregateDefinition)this.definition).getCompletionSize() != null) {
            answer.setCompletionSize(((AggregateDefinition)this.definition).getCompletionSize().intValue());
        }
        if (((AggregateDefinition)this.definition).getCompletionFromBatchConsumer() != null) {
            answer.setCompletionFromBatchConsumer(((AggregateDefinition)this.definition).getCompletionFromBatchConsumer().booleanValue());
        }
        if (((AggregateDefinition)this.definition).getCompletionOnNewCorrelationGroup() != null) {
            answer.setCompletionOnNewCorrelationGroup(((AggregateDefinition)this.definition).getCompletionOnNewCorrelationGroup().booleanValue());
        }
        if (((AggregateDefinition)this.definition).getEagerCheckCompletion() != null) {
            answer.setEagerCheckCompletion(((AggregateDefinition)this.definition).getEagerCheckCompletion().booleanValue());
        }
        if (((AggregateDefinition)this.definition).getIgnoreInvalidCorrelationKeys() != null) {
            answer.setIgnoreInvalidCorrelationKeys(((AggregateDefinition)this.definition).getIgnoreInvalidCorrelationKeys().booleanValue());
        }
        if (((AggregateDefinition)this.definition).getCloseCorrelationKeyOnCompletion() != null) {
            answer.setCloseCorrelationKeyOnCompletion(((AggregateDefinition)this.definition).getCloseCorrelationKeyOnCompletion());
        }
        if (((AggregateDefinition)this.definition).getDiscardOnCompletionTimeout() != null) {
            answer.setDiscardOnCompletionTimeout(((AggregateDefinition)this.definition).getDiscardOnCompletionTimeout().booleanValue());
        }
        if (((AggregateDefinition)this.definition).getForceCompletionOnStop() != null) {
            answer.setForceCompletionOnStop(((AggregateDefinition)this.definition).getForceCompletionOnStop().booleanValue());
        }
        if (((AggregateDefinition)this.definition).getCompleteAllOnStop() != null) {
            answer.setCompleteAllOnStop(((AggregateDefinition)this.definition).getCompleteAllOnStop().booleanValue());
        }
        if (((AggregateDefinition)this.definition).getOptimisticLockRetryPolicy() == null) {
            if (((AggregateDefinition)this.definition).getOptimisticLockRetryPolicyDefinition() != null) {
                answer.setOptimisticLockRetryPolicy(AggregateReifier.createOptimisticLockRetryPolicy(((AggregateDefinition)this.definition).getOptimisticLockRetryPolicyDefinition()));
            }
        } else {
            answer.setOptimisticLockRetryPolicy(((AggregateDefinition)this.definition).getOptimisticLockRetryPolicy());
        }
        if (((AggregateDefinition)this.definition).getAggregateController() != null) {
            answer.setAggregateController(((AggregateDefinition)this.definition).getAggregateController());
        }
        if (((AggregateDefinition)this.definition).getCompletionTimeoutCheckerInterval() != null) {
            answer.setCompletionTimeoutCheckerInterval(((AggregateDefinition)this.definition).getCompletionTimeoutCheckerInterval().longValue());
        }
        return answer;
    }

    public static OptimisticLockRetryPolicy createOptimisticLockRetryPolicy(OptimisticLockRetryPolicyDefinition definition) {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        if (definition.getMaximumRetries() != null) {
            policy.setMaximumRetries(definition.getMaximumRetries().intValue());
        }
        if (definition.getRetryDelay() != null) {
            policy.setRetryDelay(definition.getRetryDelay().longValue());
        }
        if (definition.getMaximumRetryDelay() != null) {
            policy.setMaximumRetryDelay(definition.getMaximumRetryDelay().longValue());
        }
        if (definition.getExponentialBackOff() != null) {
            policy.setExponentialBackOff(definition.getExponentialBackOff().booleanValue());
        }
        if (definition.getRandomBackOff() != null) {
            policy.setRandomBackOff(definition.getRandomBackOff().booleanValue());
        }
        return policy;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = ((AggregateDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((AggregateDefinition)this.definition).getStrategyRef() != null) {
            Object aggStrategy = routeContext.lookup(((AggregateDefinition)this.definition).getStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((AggregateDefinition)this.definition).getAggregationStrategyMethodName());
                if (((AggregateDefinition)this.definition).getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(((AggregateDefinition)this.definition).getStrategyMethodAllowNull().booleanValue());
                    adapter.setAllowNullOldExchange(((AggregateDefinition)this.definition).getStrategyMethodAllowNull().booleanValue());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((AggregateDefinition)this.definition).getStrategyRef());
            }
        }
        if (strategy == null) {
            throw new IllegalArgumentException("AggregationStrategy or AggregationStrategyRef must be set on " + this);
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(routeContext.getCamelContext());
        }
        return strategy;
    }

    private AggregationRepository createAggregationRepository(RouteContext routeContext) {
        AggregationRepository repository = ((AggregateDefinition)this.definition).getAggregationRepository();
        if (repository == null && ((AggregateDefinition)this.definition).getAggregationRepositoryRef() != null) {
            repository = (AggregationRepository)routeContext.mandatoryLookup(((AggregateDefinition)this.definition).getAggregationRepositoryRef(), AggregationRepository.class);
        }
        return repository;
    }
}

