/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Predicate;
import org.apache.camel.model.OtherAttributesAware;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="language", title="Expression")
@XmlRootElement
@XmlType(name="expression")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExpressionDefinition
implements Expression,
Predicate,
OtherAttributesAware,
ExpressionFactory {
    @XmlAttribute
    @XmlID
    private String id;
    @XmlValue
    @Metadata(required=true)
    private String expression;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean trim;
    @XmlTransient
    private Predicate predicate;
    @XmlTransient
    private Expression expressionValue;
    @XmlTransient
    private ExpressionDefinition expressionType;
    @XmlAnyAttribute
    private Map<QName, Object> otherAttributes;

    public ExpressionDefinition() {
    }

    public ExpressionDefinition(String expression) {
        this.expression = expression;
    }

    public ExpressionDefinition(Predicate predicate) {
        this.predicate = predicate;
    }

    public ExpressionDefinition(Expression expression) {
        this.expressionValue = expression;
    }

    public static String getLabel(List<ExpressionDefinition> expressions) {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        for (ExpressionDefinition expression : expressions) {
            buffer.append((Object)expression.getLabel());
        }
        return buffer.toString();
    }

    public String toString() {
        if (this.getExpressionValue() != null) {
            return this.getExpressionValue().toString();
        }
        StringBuilder sb = new StringBuilder();
        if (this.getLanguage() != null) {
            sb.append(this.getLanguage()).append("{");
        }
        if (this.getPredicate() != null) {
            sb.append(this.getPredicate().toString());
        } else if (this.getExpression() != null) {
            sb.append(this.getExpression());
        }
        if (this.getLanguage() != null) {
            sb.append("}");
        }
        return sb.toString();
    }

    public Object evaluate(Exchange exchange) {
        return this.evaluate(exchange, Object.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.expressionValue == null) {
            this.expressionValue = this.createExpression(exchange.getContext());
        }
        ObjectHelper.notNull((Object)this.expressionValue, (String)"expressionValue");
        return (T)this.expressionValue.evaluate(exchange, type);
    }

    public void assertMatches(String text, Exchange exchange) throws AssertionError {
        if (!this.matches(exchange)) {
            throw new AssertionError((Object)(text + this.getExpression() + " for exchange: " + exchange));
        }
    }

    public boolean matches(Exchange exchange) {
        if (this.predicate == null) {
            this.predicate = this.createPredicate(exchange.getContext());
        }
        ObjectHelper.notNull((Object)this.predicate, (String)"predicate");
        return this.predicate.matches(exchange);
    }

    public String getLanguage() {
        return "";
    }

    public final Predicate createPredicate(RouteContext routeContext) {
        return this.createPredicate(routeContext.getCamelContext());
    }

    public Predicate createPredicate(CamelContext camelContext) {
        if (this.predicate == null) {
            if (this.getExpressionType() != null) {
                this.predicate = this.getExpressionType().createPredicate(camelContext);
            } else if (this.getExpressionValue() != null) {
                this.predicate = new ExpressionToPredicateAdapter(this.getExpressionValue());
            } else if (this.getExpression() != null) {
                boolean isTrim;
                ObjectHelper.notNull((Object)"language", (String)this.getLanguage());
                Language language = camelContext.resolveLanguage(this.getLanguage());
                if (language == null) {
                    throw new NoSuchLanguageException(this.getLanguage());
                }
                String exp = this.getExpression();
                boolean bl = isTrim = this.getTrim() == null || this.getTrim() != false;
                if (exp != null && isTrim) {
                    exp = exp.trim();
                }
                exp = ScriptHelper.resolveOptionalExternalScript((CamelContext)camelContext, (String)exp);
                this.predicate = language.createPredicate(exp);
                this.configurePredicate(camelContext, this.predicate);
            }
        }
        if (this.predicate instanceof CamelContextAware) {
            ((CamelContextAware)this.predicate).setCamelContext(camelContext);
        }
        return this.predicate;
    }

    public final Expression createExpression(RouteContext routeContext) {
        return this.createExpression(routeContext.getCamelContext());
    }

    public Expression createExpression(CamelContext camelContext) {
        if (this.getExpressionValue() == null) {
            if (this.getExpressionType() != null) {
                this.setExpressionValue(this.getExpressionType().createExpression(camelContext));
            } else if (this.getExpression() != null) {
                boolean isTrim;
                ObjectHelper.notNull((Object)"language", (String)this.getLanguage());
                Language language = camelContext.resolveLanguage(this.getLanguage());
                if (language == null) {
                    throw new NoSuchLanguageException(this.getLanguage());
                }
                String exp = this.getExpression();
                boolean bl = isTrim = this.getTrim() == null || this.getTrim() != false;
                if (exp != null && isTrim) {
                    exp = exp.trim();
                }
                exp = ScriptHelper.resolveOptionalExternalScript((CamelContext)camelContext, (String)exp);
                this.setExpressionValue(language.createExpression(exp));
                this.configureExpression(camelContext, this.getExpressionValue());
            }
        }
        if (this.getExpressionValue() instanceof CamelContextAware) {
            ((CamelContextAware)this.getExpressionValue()).setCamelContext(camelContext);
        }
        return this.getExpressionValue();
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Expression getExpressionValue() {
        return this.expressionValue;
    }

    protected void setExpressionValue(Expression expressionValue) {
        this.expressionValue = expressionValue;
    }

    public ExpressionDefinition getExpressionType() {
        return this.expressionType;
    }

    public Boolean getTrim() {
        return this.trim;
    }

    public void setTrim(Boolean trim) {
        this.trim = trim;
    }

    @Override
    public Map<QName, Object> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    public void setOtherAttributes(Map<QName, Object> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String getLabel() {
        Predicate predicate = this.getPredicate();
        if (predicate != null) {
            return predicate.toString();
        }
        Expression expressionValue = this.getExpressionValue();
        if (expressionValue != null) {
            return expressionValue.toString();
        }
        String exp = this.getExpression();
        return exp != null ? exp : "";
    }

    protected void setExpressionType(ExpressionDefinition expressionType) {
        this.expressionType = expressionType;
    }

    protected void configurePredicate(CamelContext camelContext, Predicate predicate) {
        if (predicate instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)predicate).afterPropertiesConfigured(camelContext);
        }
    }

    protected void configureExpression(CamelContext camelContext, Expression expression) {
        if (expression instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)expression).afterPropertiesConfigured(camelContext);
        }
    }

    protected void setProperty(CamelContext camelContext, Object bean, String name, Object value) {
        try {
            IntrospectionSupport.setProperty((CamelContext)camelContext, (Object)bean, (String)name, (Object)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property " + name + " on " + bean + ". Reason: " + e, e);
        }
    }
}

