/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.TimeUnitAdapter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;

@Metadata(label="eip,routing")
@XmlRootElement(name="threads")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreadsDefinition
extends NoOutputDefinition<ThreadsDefinition>
implements ExecutorServiceAwareDefinition<ThreadsDefinition> {
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Integer poolSize;
    @XmlAttribute
    private Integer maxPoolSize;
    @XmlAttribute
    private Long keepAliveTime;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    private TimeUnit timeUnit;
    @XmlAttribute
    private Integer maxQueueSize;
    @XmlAttribute
    private Boolean allowCoreThreadTimeOut;
    @XmlAttribute
    @Metadata(defaultValue="Threads")
    private String threadName = "Threads";
    @XmlAttribute
    private ThreadPoolRejectedPolicy rejectedPolicy;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean callerRunsWhenRejected;

    public String getShortName() {
        return "threads";
    }

    @Override
    public String getLabel() {
        return "threads";
    }

    public String toString() {
        return "Threads[" + this.getOutputs() + "]";
    }

    @Override
    public ThreadsDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public ThreadsDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public ThreadsDefinition poolSize(int poolSize) {
        this.setPoolSize(poolSize);
        return this;
    }

    public ThreadsDefinition maxPoolSize(int maxPoolSize) {
        this.setMaxPoolSize(maxPoolSize);
        return this;
    }

    public ThreadsDefinition keepAliveTime(long keepAliveTime) {
        this.setKeepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadsDefinition timeUnit(TimeUnit keepAliveTimeUnits) {
        this.setTimeUnit(keepAliveTimeUnits);
        return this;
    }

    public ThreadsDefinition maxQueueSize(int maxQueueSize) {
        this.setMaxQueueSize(maxQueueSize);
        return this;
    }

    public ThreadsDefinition rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.setRejectedPolicy(rejectedPolicy);
        return this;
    }

    public ThreadsDefinition threadName(String threadName) {
        this.setThreadName(threadName);
        return this;
    }

    public ThreadsDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(callerRunsWhenRejected);
        return this;
    }

    public ThreadsDefinition allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Integer getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public Long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(Long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public void setRejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }

    public Boolean getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(Boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    public Boolean getAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void setAllowCoreThreadTimeOut(Boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }
}

