/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="split")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SplitDefinition
extends ExpressionNode
implements ExecutorServiceAwareDefinition<SplitDefinition> {
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private Boolean parallelProcessing;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private String strategyMethodName;
    @XmlAttribute
    private Boolean strategyMethodAllowNull;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Boolean streaming;
    @XmlAttribute
    private Boolean stopOnException;
    @XmlAttribute
    @Metadata(defaultValue="0")
    private Long timeout;
    @XmlAttribute
    private String onPrepareRef;
    @XmlTransient
    private Processor onPrepare;
    @XmlAttribute
    private Boolean shareUnitOfWork;
    @XmlAttribute
    private Boolean parallelAggregate;
    @XmlAttribute
    private Boolean stopOnAggregateException;

    public SplitDefinition() {
    }

    public SplitDefinition(Expression expression) {
        super(expression);
    }

    public SplitDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public String toString() {
        return "Split[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    public String getShortName() {
        return "split";
    }

    @Override
    public String getLabel() {
        return "split[" + this.getExpression() + "]";
    }

    public SplitDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public SplitDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setStrategyRef(aggregationStrategyRef);
        return this;
    }

    public SplitDefinition aggregationStrategyMethodName(String methodName) {
        this.setStrategyMethodName(methodName);
        return this;
    }

    public SplitDefinition aggregationStrategyMethodAllowNull() {
        this.setStrategyMethodAllowNull(true);
        return this;
    }

    public SplitDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public SplitDefinition parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    public SplitDefinition parallelAggregate() {
        this.setParallelAggregate(true);
        return this;
    }

    public SplitDefinition stopOnAggregateException() {
        this.setStopOnAggregateException(true);
        return this;
    }

    public SplitDefinition streaming() {
        this.setStreaming(true);
        return this;
    }

    public SplitDefinition stopOnException() {
        this.setStopOnException(true);
        return this;
    }

    @Override
    public SplitDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public SplitDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public SplitDefinition onPrepare(Processor onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public SplitDefinition onPrepareRef(String onPrepareRef) {
        this.setOnPrepareRef(onPrepareRef);
        return this;
    }

    public SplitDefinition timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public SplitDefinition shareUnitOfWork() {
        this.setShareUnitOfWork(true);
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public Boolean getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(Boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public Boolean getStreaming() {
        return this.streaming;
    }

    public void setStreaming(Boolean streaming) {
        this.streaming = streaming;
    }

    public Boolean getParallelAggregate() {
        return this.parallelAggregate;
    }

    public void setParallelAggregate(Boolean parallelAggregate) {
        this.parallelAggregate = parallelAggregate;
    }

    public Boolean getStopOnAggregateException() {
        return this.stopOnAggregateException;
    }

    public void setStopOnAggregateException(Boolean stopOnAggregateException) {
        this.stopOnAggregateException = stopOnAggregateException;
    }

    public Boolean getStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(Boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public Boolean isStopOnException() {
        return this.stopOnException != null && this.stopOnException != false;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public String getStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public Boolean getStrategyMethodAllowNull() {
        return this.strategyMethodAllowNull;
    }

    public void setStrategyMethodAllowNull(Boolean strategyMethodAllowNull) {
        this.strategyMethodAllowNull = strategyMethodAllowNull;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getOnPrepareRef() {
        return this.onPrepareRef;
    }

    public void setOnPrepareRef(String onPrepareRef) {
        this.onPrepareRef = onPrepareRef;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public Boolean getShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(Boolean shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }
}

