/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Predicate;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OnCompletionMode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="onCompletion")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnCompletionDefinition
extends ProcessorDefinition<OnCompletionDefinition>
implements ExecutorServiceAwareDefinition<OnCompletionDefinition> {
    @XmlAttribute
    @Metadata(defaultValue="AfterConsumer")
    private OnCompletionMode mode;
    @XmlAttribute
    private Boolean onCompleteOnly;
    @XmlAttribute
    private Boolean onFailureOnly;
    @XmlElement(name="onWhen")
    @AsPredicate
    private WhenDefinition onWhen;
    @XmlAttribute
    private Boolean parallelProcessing;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute(name="useOriginalMessage")
    private Boolean useOriginalMessagePolicy;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();
    @XmlTransient
    private ExecutorService executorService;
    @XmlTransient
    private Boolean routeScoped;

    public boolean isRouteScoped() {
        return this.routeScoped != null ? this.routeScoped : false;
    }

    public Boolean getRouteScoped() {
        return this.routeScoped;
    }

    public String toString() {
        return "onCompletion[" + this.getOutputs() + "]";
    }

    public String getShortName() {
        return "onCompletion";
    }

    @Override
    public String getLabel() {
        return "onCompletion";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    public void removeAllOnCompletionDefinition(ProcessorDefinition<?> definition) {
        Iterator<ProcessorDefinition<?>> it = definition.getOutputs().iterator();
        while (it.hasNext()) {
            ProcessorDefinition<?> out = it.next();
            if (!(out instanceof OnCompletionDefinition)) continue;
            it.remove();
        }
    }

    @Override
    public ProcessorDefinition<?> end() {
        this.getParent().popBlock();
        return super.end();
    }

    public OnCompletionDefinition modeAfterConsumer() {
        this.setMode(OnCompletionMode.AfterConsumer);
        return this;
    }

    public OnCompletionDefinition modeBeforeConsumer() {
        this.setMode(OnCompletionMode.BeforeConsumer);
        return this;
    }

    public OnCompletionDefinition onCompleteOnly() {
        boolean isOnFailureOnly;
        boolean bl = isOnFailureOnly = this.getOnFailureOnly() != null && this.getOnFailureOnly() != false;
        if (isOnFailureOnly) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        this.setOnCompleteOnly(Boolean.TRUE);
        this.setOnFailureOnly(Boolean.FALSE);
        return this;
    }

    public OnCompletionDefinition onFailureOnly() {
        boolean isOnCompleteOnly;
        boolean bl = isOnCompleteOnly = this.getOnCompleteOnly() != null && this.getOnCompleteOnly() != false;
        if (isOnCompleteOnly) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        this.setOnCompleteOnly(Boolean.FALSE);
        this.setOnFailureOnly(Boolean.TRUE);
        return this;
    }

    public OnCompletionDefinition onWhen(@AsPredicate Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    public OnCompletionDefinition useOriginalBody() {
        this.setUseOriginalMessagePolicy(Boolean.TRUE);
        return this;
    }

    @Override
    public OnCompletionDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public OnCompletionDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public OnCompletionDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public OnCompletionDefinition parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public OnCompletionMode getMode() {
        return this.mode;
    }

    public void setMode(OnCompletionMode mode) {
        this.mode = mode;
    }

    public Boolean getOnCompleteOnly() {
        return this.onCompleteOnly;
    }

    public void setOnCompleteOnly(Boolean onCompleteOnly) {
        this.onCompleteOnly = onCompleteOnly;
    }

    public Boolean getOnFailureOnly() {
        return this.onFailureOnly;
    }

    public void setOnFailureOnly(Boolean onFailureOnly) {
        this.onFailureOnly = onFailureOnly;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy;
    }

    public void setUseOriginalMessagePolicy(Boolean useOriginalMessagePolicy) {
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
    }

    public Boolean getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(Boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }
}

