/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.TypeConversionException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.xml.XmlLineNumberParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ModelHelper {
    private ModelHelper() {
    }

    public static String dumpModelAsXml(CamelContext context, NamedNode definition) throws JAXBException {
        Document dom;
        JAXBContext jaxbContext = ModelHelper.getJAXBContext(context);
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        if (definition instanceof RoutesDefinition) {
            List<RouteDefinition> routes = ((RoutesDefinition)definition).getRoutes();
            for (RouteDefinition route : routes) {
                ModelHelper.extractNamespaces(route, namespaces);
            }
        } else if (definition instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)definition;
            ModelHelper.extractNamespaces(route, namespaces);
        }
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)definition, (Writer)buffer);
        XmlConverter xmlConverter = ModelHelper.newXmlConverter(context);
        String xml = buffer.toString();
        try {
            dom = xmlConverter.toDOMDocument(xml, null);
        }
        catch (Exception e) {
            throw new TypeConversionException((Object)xml, Document.class, (Throwable)e);
        }
        Element documentElement = dom.getDocumentElement();
        for (String nsPrefix : namespaces.keySet()) {
            String prefix = nsPrefix.equals("xmlns") ? nsPrefix : "xmlns:" + nsPrefix;
            documentElement.setAttribute(prefix, (String)namespaces.get(nsPrefix));
        }
        Properties outputProperties = new Properties();
        outputProperties.put("indent", "yes");
        outputProperties.put("standalone", "yes");
        outputProperties.put("encoding", "UTF-8");
        try {
            return xmlConverter.toStringFromDocument(dom, outputProperties);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Failed converting document object to string", e);
        }
    }

    public static String dumpModelAsXml(final CamelContext context, NamedNode definition, final boolean resolvePlaceholders, final boolean resolveDelegateEndpoints) throws Exception {
        String xml = ModelHelper.dumpModelAsXml(context, definition);
        if (resolvePlaceholders || resolveDelegateEndpoints) {
            final AtomicBoolean changed = new AtomicBoolean();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            Document dom = XmlLineNumberParser.parseXml((InputStream)is, (XmlLineNumberParser.XmlTextTransformer)new XmlLineNumberParser.XmlTextTransformer(){
                private String prev;

                public String transform(String text) {
                    String after = text;
                    if (resolveDelegateEndpoints && "uri".equals(this.prev)) {
                        try {
                            String uri = context.resolvePropertyPlaceholders(text);
                            Endpoint endpoint = context.hasEndpoint(uri);
                            if (endpoint instanceof DelegateEndpoint) {
                                endpoint = ((DelegateEndpoint)endpoint).getEndpoint();
                                after = endpoint.getEndpointUri();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (resolvePlaceholders) {
                        try {
                            after = context.resolvePropertyPlaceholders(after);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!changed.get()) {
                        changed.set(!text.equals(after));
                    }
                    this.prev = text;
                    return after;
                }
            });
            if (changed.get()) {
                xml = (String)context.getTypeConverter().mandatoryConvertTo(String.class, (Object)dom);
                NamedNode copy = ModelHelper.createModelFromXml(context, xml, NamedNode.class);
                xml = ModelHelper.dumpModelAsXml(context, copy);
            }
        }
        return xml;
    }

    public static <T extends NamedNode> T createModelFromXml(CamelContext context, String xml, Class<T> type) throws JAXBException {
        return ModelHelper.modelToXml(context, null, xml, type);
    }

    public static <T extends NamedNode> T createModelFromXml(CamelContext context, InputStream stream, Class<T> type) throws JAXBException {
        return ModelHelper.modelToXml(context, stream, null, type);
    }

    public static RoutesDefinition loadRoutesDefinition(CamelContext context, InputStream inputStream) throws Exception {
        XmlConverter xmlConverter = ModelHelper.newXmlConverter(context);
        Document dom = xmlConverter.toDOMDocument(inputStream, null);
        return ModelHelper.loadRoutesDefinition(context, dom);
    }

    public static RoutesDefinition loadRoutesDefinition(CamelContext context, Node node) throws Exception {
        RoutesDefinition answer;
        JAXBContext jaxbContext = ModelHelper.getJAXBContext(context);
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        Document dom = node instanceof Document ? (Document)node : node.getOwnerDocument();
        ModelHelper.extractNamespaces(dom, namespaces);
        Binder binder = jaxbContext.createBinder();
        Object result = binder.unmarshal((Object)node);
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to RoutesDefinition using JAXB");
        }
        if (result instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)result;
            answer = new RoutesDefinition();
            ModelHelper.applyNamespaces(route, namespaces);
            answer.getRoutes().add(route);
        } else if (result instanceof RoutesDefinition) {
            answer = (RoutesDefinition)result;
            for (RouteDefinition route : answer.getRoutes()) {
                ModelHelper.applyNamespaces(route, namespaces);
            }
        } else {
            throw new IllegalArgumentException("Unmarshalled object is an unsupported type: " + ObjectHelper.className((Object)result) + " -> " + result);
        }
        return answer;
    }

    public static RestsDefinition loadRestsDefinition(CamelContext context, InputStream is) throws Exception {
        RestsDefinition answer;
        Unmarshaller unmarshaller = ModelHelper.getJAXBContext(context).createUnmarshaller();
        Object result = unmarshaller.unmarshal(is);
        if (result == null) {
            throw new IOException("Cannot unmarshal to rests using JAXB from input stream: " + is);
        }
        if (result instanceof RestDefinition) {
            RestDefinition rest = (RestDefinition)result;
            answer = new RestsDefinition();
            answer.getRests().add(rest);
        } else if (result instanceof RestsDefinition) {
            answer = (RestsDefinition)result;
        } else {
            throw new IllegalArgumentException("Unmarshalled object is an unsupported type: " + ObjectHelper.className((Object)result) + " -> " + result);
        }
        return answer;
    }

    private static <T extends NamedNode> T modelToXml(CamelContext context, InputStream is, String xml, Class<T> type) throws JAXBException {
        JAXBContext jaxbContext = ModelHelper.getJAXBContext(context);
        XmlConverter xmlConverter = ModelHelper.newXmlConverter(context);
        Document dom = null;
        try {
            if (is != null) {
                dom = xmlConverter.toDOMDocument(is, null);
            } else if (xml != null) {
                dom = xmlConverter.toDOMDocument(xml, null);
            }
        }
        catch (Exception e) {
            throw new TypeConversionException((Object)xml, Document.class, (Throwable)e);
        }
        if (dom == null) {
            throw new IllegalArgumentException("InputStream and XML is both null");
        }
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        ModelHelper.extractNamespaces(dom, namespaces);
        Binder binder = jaxbContext.createBinder();
        Object result = binder.unmarshal((Object)dom);
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to " + type + " using JAXB");
        }
        if (result instanceof RoutesDefinition) {
            List<RouteDefinition> routes = ((RoutesDefinition)result).getRoutes();
            for (RouteDefinition route : routes) {
                ModelHelper.applyNamespaces(route, namespaces);
            }
        } else if (result instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)result;
            ModelHelper.applyNamespaces(route, namespaces);
        }
        return (T)((NamedNode)type.cast(result));
    }

    private static JAXBContext getJAXBContext(CamelContext context) throws JAXBException {
        ModelJAXBContextFactory factory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getModelJAXBContextFactory();
        return factory.newJAXBContext();
    }

    private static void applyNamespaces(RouteDefinition route, Map<String, String> namespaces) {
        Iterator<ExpressionNode> it = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ExpressionNode.class);
        while (it.hasNext()) {
            NamespaceAware na = ModelHelper.getNamespaceAwareFromExpression(it.next());
            if (na == null) continue;
            na.setNamespaces(namespaces);
        }
    }

    private static NamespaceAware getNamespaceAwareFromExpression(ExpressionNode expressionNode) {
        ExpressionDefinition ed = expressionNode.getExpression();
        NamespaceAware na = null;
        Expression exp = ed.getExpressionValue();
        if (exp instanceof NamespaceAware) {
            na = (NamespaceAware)exp;
        } else if (ed instanceof NamespaceAware) {
            na = (NamespaceAware)ed;
        }
        return na;
    }

    private static void extractNamespaces(RouteDefinition route, Map<String, String> namespaces) {
        Iterator<ExpressionNode> it = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ExpressionNode.class);
        while (it.hasNext()) {
            Map map;
            NamespaceAware na = ModelHelper.getNamespaceAwareFromExpression(it.next());
            if (na == null || (map = na.getNamespaces()) == null || map.isEmpty()) continue;
            namespaces.putAll(map);
        }
    }

    private static void extractNamespaces(Document document, Map<String, String> namespaces) throws JAXBException {
        NamedNodeMap attributes = document.getDocumentElement().getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            String nsPrefix = item.getNodeName();
            if (nsPrefix == null || !nsPrefix.startsWith("xmlns")) continue;
            String nsValue = item.getNodeValue();
            String[] nsParts = nsPrefix.split(":");
            if (nsParts.length == 1) {
                namespaces.put(nsParts[0], nsValue);
                continue;
            }
            if (nsParts.length == 2) {
                namespaces.put(nsParts[1], nsValue);
                continue;
            }
            namespaces.put(nsPrefix, nsValue);
        }
    }

    private static XmlConverter newXmlConverter(CamelContext context) {
        XmlConverter xmlConverter;
        if (context != null) {
            TypeConverterRegistry registry = context.getTypeConverterRegistry();
            xmlConverter = (XmlConverter)registry.getInjector().newInstance(XmlConverter.class, false);
        } else {
            xmlConverter = new XmlConverter();
        }
        return xmlConverter;
    }
}

