/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.TypeConverters;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.health.HealthCheckService;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.FileWatcherReloadStrategy;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainDurationEventNotifier;
import org.apache.camel.main.MainLifecycleStrategy;
import org.apache.camel.main.MainListener;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.jsse.GlobalSSLContextParametersSupplier;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MainSupport
extends ServiceSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(MainSupport.class);
    protected static final int UNINITIALIZED_EXIT_CODE = Integer.MIN_VALUE;
    protected static final int DEFAULT_EXIT_CODE = 0;
    protected final List<MainListener> listeners = new ArrayList<MainListener>();
    protected final List<Option> options = new ArrayList<Option>();
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected final AtomicBoolean completed = new AtomicBoolean(false);
    protected final AtomicInteger exitCode = new AtomicInteger(Integer.MIN_VALUE);
    protected volatile CamelContext camelContext;
    protected volatile ProducerTemplate camelTemplate;
    protected final MainConfigurationProperties mainConfigurationProperties = new MainConfigurationProperties();
    protected List<RouteBuilder> routeBuilders = new ArrayList<RouteBuilder>();
    protected String routeBuilderClasses;
    protected List<Object> configurations = new ArrayList<Object>();
    protected String configurationClasses;
    protected String propertyPlaceholderLocations;
    protected Properties initialProperties;
    protected Properties overrideProperties;

    protected MainSupport(Class ... configurationClasses) {
        this();
        this.addConfigurationClass(configurationClasses);
    }

    protected MainSupport() {
        this.addOption(new Option("h", "help", "Displays the help screen"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                MainSupport.this.showOptions();
                MainSupport.this.completed();
            }
        });
        this.addOption(new ParameterOption("r", "routers", "Sets the router builder classes which will be loaded while starting the camel context", "routerBuilderClasses"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setRouteBuilderClasses(parameter);
            }
        });
        this.addOption(new ParameterOption("d", "duration", "Sets the time duration (seconds) that the application will run for before terminating.", "duration"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (parameter.endsWith("s") || parameter.endsWith("S")) {
                    parameter = parameter.substring(0, parameter.length() - 1);
                }
                MainSupport.this.configure().setDuration(Integer.parseInt(parameter));
            }
        });
        this.addOption(new ParameterOption("dm", "durationMaxMessages", "Sets the duration of maximum number of messages that the application will process before terminating.", "durationMaxMessages"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.configure().setDurationMaxMessages(Integer.parseInt(parameter));
            }
        });
        this.addOption(new ParameterOption("di", "durationIdle", "Sets the idle time duration (seconds) duration that the application can be idle before terminating.", "durationIdle"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (parameter.endsWith("s") || parameter.endsWith("S")) {
                    parameter = parameter.substring(0, parameter.length() - 1);
                }
                MainSupport.this.configure().setDurationMaxIdleSeconds(Integer.parseInt(parameter));
            }
        });
        this.addOption(new Option("t", "trace", "Enables tracing"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                MainSupport.this.enableTrace();
            }
        });
        this.addOption(new ParameterOption("e", "exitcode", "Sets the exit code if duration was hit", "exitcode"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.configure().setDurationHitExitCode(Integer.parseInt(parameter));
            }
        });
        this.addOption(new ParameterOption("watch", "fileWatch", "Sets a directory to watch for file changes to trigger reloading routes on-the-fly", "fileWatch"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.configure().setFileWatchDirectory(parameter);
            }
        });
        this.addOption(new ParameterOption("pl", "propertiesLocation", "Sets location(s) to load properties, such as from classpath or file system.", "propertiesLocation"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setPropertyPlaceholderLocations(parameter);
            }
        });
    }

    public void run() throws Exception {
        if (!this.completed.get()) {
            this.internalBeforeStart();
            this.beforeStart();
            this.start();
            try {
                this.afterStart();
                this.waitUntilCompleted();
                this.internalBeforeStop();
                this.beforeStop();
                this.stop();
                this.afterStop();
            }
            catch (Exception e) {
                LOG.error("Failed: {}", (Object)e, (Object)e);
            }
        }
    }

    public void disableHangupSupport() {
        this.mainConfigurationProperties.setHangupInterceptorEnabled(false);
    }

    public void enableHangupSupport() {
        this.mainConfigurationProperties.setHangupInterceptorEnabled(true);
    }

    public void addMainListener(MainListener listener) {
        this.listeners.add(listener);
    }

    public void removeMainListener(MainListener listener) {
        this.listeners.remove(listener);
    }

    protected void beforeStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStart(this);
        }
    }

    protected void afterStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStart(this);
        }
    }

    private void internalBeforeStart() {
        if (this.mainConfigurationProperties.isHangupInterceptorEnabled()) {
            String threadName = ThreadHelper.resolveThreadName(null, (String)"CamelHangupInterceptor");
            HangupInterceptor task = new HangupInterceptor(this);
            task.setName(threadName);
            Runtime.getRuntime().addShutdownHook(task);
        }
    }

    protected void beforeStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStop(this);
        }
    }

    protected void afterStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStop(this);
        }
    }

    private void internalBeforeStop() {
        try {
            if (this.camelTemplate != null) {
                ServiceHelper.stopService((Object)this.camelTemplate);
                this.camelTemplate = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Error stopping camelTemplate due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
        }
    }

    public void completed() {
        this.completed.set(true);
        this.exitCode.compareAndSet(Integer.MIN_VALUE, 0);
        this.latch.countDown();
    }

    public void showOptions() {
        this.showOptionsHeader();
        for (Option option : this.options) {
            System.out.println(option.getInformation());
        }
    }

    public void parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        boolean valid = true;
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            boolean handled = false;
            for (Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            System.out.println("Unknown option: " + arg);
            System.out.println();
            valid = false;
            break;
        }
        if (!valid) {
            this.showOptions();
            this.completed();
        }
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public MainConfigurationProperties configure() {
        return this.mainConfigurationProperties;
    }

    @Deprecated
    public long getDuration() {
        return this.mainConfigurationProperties.getDuration();
    }

    @Deprecated
    public void setDuration(long duration) {
        this.mainConfigurationProperties.setDuration(duration);
    }

    @Deprecated
    public int getDurationIdle() {
        return this.mainConfigurationProperties.getDurationMaxIdleSeconds();
    }

    @Deprecated
    public void setDurationIdle(int durationIdle) {
        this.mainConfigurationProperties.setDurationMaxIdleSeconds(durationIdle);
    }

    @Deprecated
    public int getDurationMaxMessages() {
        return this.mainConfigurationProperties.getDurationMaxMessages();
    }

    @Deprecated
    public void setDurationMaxMessages(int durationMaxMessages) {
        this.mainConfigurationProperties.setDurationMaxMessages(durationMaxMessages);
    }

    @Deprecated
    public void setDurationHitExitCode(int durationHitExitCode) {
        this.mainConfigurationProperties.setDurationHitExitCode(durationHitExitCode);
    }

    @Deprecated
    public int getDurationHitExitCode() {
        return this.mainConfigurationProperties.getDurationHitExitCode();
    }

    public int getExitCode() {
        return this.exitCode.get();
    }

    public String getConfigurationClasses() {
        return this.configurationClasses;
    }

    public void setConfigurationClasses(String configurations) {
        this.configurationClasses = configurations;
    }

    public void addConfigurationClass(Class ... configuration) {
        String existing = this.configurationClasses;
        if (existing == null) {
            existing = "";
        }
        if (configuration != null) {
            for (Class clazz : configuration) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setConfigurationClasses(existing);
    }

    public void addConfiguration(Object configuration) {
        this.configurations.add(configuration);
    }

    public String getRouteBuilderClasses() {
        return this.routeBuilderClasses;
    }

    public void setRouteBuilderClasses(String builders) {
        this.routeBuilderClasses = builders;
    }

    @Deprecated
    public String getFileWatchDirectory() {
        return this.mainConfigurationProperties.getFileWatchDirectory();
    }

    @Deprecated
    public void setFileWatchDirectory(String fileWatchDirectory) {
        this.mainConfigurationProperties.setFileWatchDirectory(fileWatchDirectory);
    }

    @Deprecated
    public boolean isFileWatchDirectoryRecursively() {
        return this.mainConfigurationProperties.isFileWatchDirectoryRecursively();
    }

    @Deprecated
    public void setFileWatchDirectoryRecursively(boolean fileWatchDirectoryRecursively) {
        this.mainConfigurationProperties.setFileWatchDirectoryRecursively(fileWatchDirectoryRecursively);
    }

    @Deprecated
    public ReloadStrategy getReloadStrategy() {
        return this.mainConfigurationProperties.getReloadStrategy();
    }

    @Deprecated
    public void setReloadStrategy(ReloadStrategy reloadStrategy) {
        this.mainConfigurationProperties.setReloadStrategy(reloadStrategy);
    }

    public String getPropertyPlaceholderLocations() {
        return this.propertyPlaceholderLocations;
    }

    public void setPropertyPlaceholderLocations(String location) {
        this.propertyPlaceholderLocations = location;
    }

    @Deprecated
    public boolean isAutoConfigurationEnabled() {
        return this.mainConfigurationProperties.isAutoConfigurationEnabled();
    }

    @Deprecated
    public void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.mainConfigurationProperties.setAutoConfigurationEnabled(autoConfigurationEnabled);
    }

    public Properties getInitialProperties() {
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public boolean isTrace() {
        return this.mainConfigurationProperties.isTracing();
    }

    public void enableTrace() {
        this.mainConfigurationProperties.setTracing(true);
    }

    protected void doStop() throws Exception {
        this.completed();
    }

    protected void doStart() throws Exception {
    }

    protected void waitUntilCompleted() {
        while (!this.completed.get()) {
            try {
                int idle = this.mainConfigurationProperties.getDurationMaxIdleSeconds();
                int max = this.mainConfigurationProperties.getDurationMaxMessages();
                if (this.mainConfigurationProperties.getDuration() > 0L) {
                    LOG.info("Waiting for: {} seconds", (Object)this.mainConfigurationProperties.getDuration());
                    this.latch.await(this.mainConfigurationProperties.getDuration(), TimeUnit.SECONDS);
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.mainConfigurationProperties.getDurationHitExitCode());
                    this.completed.set(true);
                    continue;
                }
                if (idle > 0 || max > 0) {
                    if (idle > 0 && max > 0) {
                        LOG.info("Waiting to be idle for: {} seconds or until: {} messages has been processed", (Object)idle, (Object)max);
                    } else if (idle > 0) {
                        LOG.info("Waiting to be idle for: {} seconds", (Object)idle);
                    } else {
                        LOG.info("Waiting until: {} messages has been processed", (Object)max);
                    }
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.mainConfigurationProperties.getDurationHitExitCode());
                    this.latch.await();
                    this.completed.set(true);
                    continue;
                }
                this.latch.await();
            }
            catch (InterruptedException e) {
                this.completed.set(true);
                this.latch.countDown();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void run(String[] args) throws Exception {
        this.parseArguments(args);
        this.run();
        LOG.info("MainSupport exiting code: {}", (Object)this.getExitCode());
    }

    public void showOptionsHeader() {
        System.out.println("Apache Camel Runner takes the following options");
        System.out.println();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public List<RouteBuilder> getRouteBuilders() {
        return this.routeBuilders;
    }

    public void setRouteBuilders(List<RouteBuilder> routeBuilders) {
        this.routeBuilders = routeBuilders;
    }

    public List<Object> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Object> configurations) {
        this.configurations = configurations;
    }

    public List<RouteDefinition> getRouteDefinitions() {
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        if (this.camelContext != null) {
            answer.addAll(((Model)this.camelContext.getExtension(Model.class)).getRouteDefinitions());
        }
        return answer;
    }

    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.findOrCreateCamelTemplate();
        }
        return this.camelTemplate;
    }

    protected abstract ProducerTemplate findOrCreateCamelTemplate();

    protected abstract CamelContext createCamelContext();

    protected void initCamelContext() throws Exception {
        this.camelContext = this.createCamelContext();
        this.postProcessCamelContext(this.camelContext);
    }

    protected void loadRouteBuilders(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (RouteBuilder routeBuilder : this.getRouteBuilders()) {
            postProcessor.postProcessBeforeInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
            postProcessor.postProcessAfterInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
        }
        if (this.routeBuilderClasses != null) {
            String[] routeClasses;
            for (String routeClass : routeClasses = this.routeBuilderClasses.split(",")) {
                Class routeClazz = camelContext.getClassResolver().resolveClass(routeClass);
                Object builder = camelContext.getInjector().newInstance(routeClazz);
                if (builder instanceof RouteBuilder) {
                    this.getRouteBuilders().add((RouteBuilder)builder);
                    continue;
                }
                LOG.warn("Class {} is not a RouteBuilder class", (Object)routeClazz);
            }
        }
    }

    protected void loadConfigurations(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (Object object : this.getConfigurations()) {
            postProcessor.postProcessBeforeInitialization(object, object.getClass().getName());
            postProcessor.postProcessAfterInitialization(object, object.getClass().getName());
        }
        if (this.configurationClasses != null) {
            String[] configClasses;
            for (String configClass : configClasses = this.configurationClasses.split(",")) {
                Class configClazz = camelContext.getClassResolver().resolveClass(configClass);
                Object config = camelContext.getInjector().newInstance(configClazz);
                this.getConfigurations().add(config);
            }
        }
        for (Object object : this.getConfigurations()) {
            Method method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[0]);
            if (method == null) continue;
            this.log.info("Calling configure method on configuration class: {}", (Object)object.getClass().getName());
            ObjectHelper.invokeMethod((Method)method, (Object)object, (Object[])new Object[0]);
        }
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        PropertiesComponent pc;
        if (this.propertyPlaceholderLocations != null) {
            pc = camelContext.getPropertiesComponent();
            pc.addLocation(this.propertyPlaceholderLocations);
            if (this.initialProperties != null) {
                pc.setInitialProperties(this.initialProperties);
            }
            if (this.overrideProperties != null) {
                pc.setOverrideProperties(this.overrideProperties);
            }
            LOG.info("Using properties from: {}", (Object)this.propertyPlaceholderLocations);
        } else {
            pc = camelContext.getPropertiesComponent();
            pc.addLocation("classpath:application.properties");
            pc.setIgnoreMissingLocation(true);
            if (this.initialProperties != null) {
                pc.setInitialProperties(this.initialProperties);
            }
            if (this.overrideProperties != null) {
                pc.setOverrideProperties(this.overrideProperties);
            }
            LOG.info("Using optional properties from classpath:application.properties");
        }
        if (this.mainConfigurationProperties.getFileWatchDirectory() != null) {
            FileWatcherReloadStrategy reload = new FileWatcherReloadStrategy(this.mainConfigurationProperties.getFileWatchDirectory(), this.mainConfigurationProperties.isFileWatchDirectoryRecursively());
            camelContext.setReloadStrategy((ReloadStrategy)reload);
            camelContext.addService((Object)reload);
            Object managedObject = camelContext.getManagementStrategy().getManagementObjectStrategy().getManagedObjectForService(camelContext, (Service)reload);
            if (managedObject == null) {
                return;
            }
            if (camelContext.getManagementStrategy().isManaged(managedObject)) {
                LOG.trace("The service is already managed: {}", (Object)reload);
                return;
            }
            try {
                camelContext.getManagementStrategy().manageObject(managedObject);
            }
            catch (Exception e) {
                LOG.warn("Could not register service: " + (Object)((Object)reload) + " as Service MBean.", (Throwable)e);
            }
        }
        if (this.mainConfigurationProperties.getDurationMaxMessages() > 0 || this.mainConfigurationProperties.getDurationMaxIdleSeconds() > 0) {
            MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.mainConfigurationProperties.getDurationMaxMessages(), this.mainConfigurationProperties.getDurationMaxIdleSeconds(), this.completed, this.latch, true);
            ServiceHelper.startService((Object)((Object)notifier));
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationPropertiesComponent(camelContext);
            this.autoConfigurationMainConfiguration(camelContext, this.mainConfigurationProperties);
        }
        this.doConfigureCamelContextFromMainConfiguration(camelContext, this.mainConfigurationProperties);
        this.loadConfigurations(camelContext);
        if (this.mainConfigurationProperties.isAutowireComponentProperties() || this.mainConfigurationProperties.isAutowireComponentPropertiesDeep()) {
            this.autoConfigurationFromRegistry(camelContext, this.mainConfigurationProperties.isAutowireComponentPropertiesDeep());
        }
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFromProperties(camelContext);
        }
        this.loadRouteBuilders(camelContext);
        for (RouteBuilder routeBuilder : this.routeBuilders) {
            camelContext.addRoutes((RoutesBuilder)routeBuilder);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new MainLifecycleStrategy(this.completed, this.latch));
        for (MainListener listener : this.listeners) {
            listener.configure(camelContext);
        }
    }

    protected void doConfigureCamelContextFromMainConfiguration(CamelContext camelContext, MainConfigurationProperties config) throws Exception {
        if (config.getFileConfigurations() != null) {
            String[] locs;
            for (String loc : locs = config.getFileConfigurations().split(",")) {
                String pattern;
                File[] files;
                String path = FileUtil.onlyPath((String)loc);
                if (path == null || (files = new File(path).listFiles(arg_0 -> MainSupport.lambda$doConfigureCamelContextFromMainConfiguration$0(pattern = loc.length() > path.length() ? loc.substring(path.length() + 1) : null, arg_0))) == null) continue;
                for (File file : files) {
                    Properties props = new Properties();
                    try (FileInputStream is = new FileInputStream(file);){
                        props.load(is);
                    }
                    if (props.isEmpty()) continue;
                    if (this.overrideProperties == null) {
                        this.overrideProperties = new Properties();
                        PropertiesComponent pc = camelContext.getPropertiesComponent();
                        pc.setOverrideProperties(this.overrideProperties);
                    }
                    LOG.info("Loaded additional {} properties from file: {}", (Object)props.size(), (Object)file);
                    this.overrideProperties.putAll((Map<?, ?>)props);
                }
            }
        }
        if (!config.isJmxEnabled()) {
            camelContext.disableJMX();
        }
        if (config.getName() != null) {
            ((DefaultCamelContext)camelContext).setName(config.getName());
        }
        if (config.getShutdownTimeout() > 0) {
            camelContext.getShutdownStrategy().setTimeout((long)config.getShutdownTimeout());
        }
        camelContext.getShutdownStrategy().setSuppressLoggingOnTimeout(config.isShutdownSuppressLoggingOnTimeout());
        camelContext.getShutdownStrategy().setShutdownNowOnTimeout(config.isShutdownNowOnTimeout());
        camelContext.getShutdownStrategy().setShutdownRoutesInReverseOrder(config.isShutdownRoutesInReverseOrder());
        camelContext.getShutdownStrategy().setLogInflightExchangesOnTimeout(config.isShutdownLogInflightExchangesOnTimeout());
        if (config.getLogDebugMaxChars() != 0) {
            camelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", "" + config.getLogDebugMaxChars());
        }
        camelContext.setStreamCaching(Boolean.valueOf(config.isStreamCachingEnabled()));
        camelContext.getStreamCachingStrategy().setAnySpoolRules(config.isStreamCachingAnySpoolRules());
        camelContext.getStreamCachingStrategy().setBufferSize(config.getStreamCachingBufferSize());
        camelContext.getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(config.isStreamCachingRemoveSpoolDirectoryWhenStopping());
        camelContext.getStreamCachingStrategy().setSpoolCipher(config.getStreamCachingSpoolCipher());
        if (config.getStreamCachingSpoolDirectory() != null) {
            camelContext.getStreamCachingStrategy().setSpoolDirectory(config.getStreamCachingSpoolDirectory());
        }
        if (config.getStreamCachingSpoolThreshold() != 0L) {
            camelContext.getStreamCachingStrategy().setSpoolThreshold(config.getStreamCachingSpoolThreshold());
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryLimit() != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit;
            if ("Committed".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed;
            } else if ("Max".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
            } else {
                throw new IllegalArgumentException("Invalid option " + config.getStreamCachingSpoolUsedHeapMemoryLimit() + " must either be Committed or Max");
            }
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(limit);
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryThreshold() != 0) {
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(config.getStreamCachingSpoolUsedHeapMemoryThreshold());
        }
        camelContext.setMessageHistory(Boolean.valueOf(config.isMessageHistory()));
        camelContext.setLogMask(Boolean.valueOf(config.isLogMask()));
        camelContext.setLogExhaustedMessageBody(Boolean.valueOf(config.isLogExhaustedMessageBody()));
        camelContext.setHandleFault(Boolean.valueOf(config.isHandleFault()));
        camelContext.setAutoStartup(Boolean.valueOf(config.isAutoStartup()));
        camelContext.setAllowUseOriginalMessage(Boolean.valueOf(config.isAllowUseOriginalMessage()));
        camelContext.setUseBreadcrumb(Boolean.valueOf(config.isUseBreadcrumb()));
        camelContext.setUseDataType(Boolean.valueOf(config.isUseDataType()));
        camelContext.setUseMDCLogging(Boolean.valueOf(config.isUseMdcLogging()));
        if (camelContext.getManagementStrategy().getManagementAgent() != null) {
            camelContext.getManagementStrategy().getManagementAgent().setEndpointRuntimeStatisticsEnabled(Boolean.valueOf(config.isEndpointRuntimeStatisticsEnabled()));
            camelContext.getManagementStrategy().getManagementAgent().setStatisticsLevel(config.getJmxManagementStatisticsLevel());
            camelContext.getManagementStrategy().getManagementAgent().setManagementNamePattern(config.getJmxManagementNamePattern());
            camelContext.getManagementStrategy().getManagementAgent().setCreateConnector(Boolean.valueOf(config.isJmxCreateConnector()));
        }
        camelContext.setTracing(Boolean.valueOf(config.isTracing()));
        if (config.getThreadNamePattern() != null) {
            camelContext.getExecutorServiceManager().setThreadNamePattern(config.getThreadNamePattern());
        }
        MainSupport.afterPropertiesSet(camelContext.getRegistry(), camelContext);
        Properties prop = camelContext.getPropertiesComponent().loadProperties();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.context.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(14);
            properties.put(option, value);
        }
        if (!properties.isEmpty()) {
            LOG.info("Auto configuring CamelContext from loaded properties: {}", (Object)properties.size());
        }
        MainSupport.setCamelProperties(camelContext, camelContext, properties, true);
    }

    static void afterPropertiesSet(Registry registry, CamelContext camelContext) throws Exception {
        HealthCheckRegistry healthCheckRegistry;
        ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
        MainSupport.registerPropertyForBeanType(registry, BacklogTracer.class, bt -> camelContext.setExtension(BacklogTracer.class, bt));
        MainSupport.registerPropertyForBeanType(registry, HandleFault.class, arg_0 -> ((ExtendedCamelContext)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class))).addInterceptStrategy(arg_0));
        MainSupport.registerPropertyForBeanType(registry, InflightRepository.class, arg_0 -> ((CamelContext)camelContext).setInflightRepository(arg_0));
        MainSupport.registerPropertyForBeanType(registry, AsyncProcessorAwaitManager.class, arg_0 -> ((ExtendedCamelContext)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class))).setAsyncProcessorAwaitManager(arg_0));
        MainSupport.registerPropertyForBeanType(registry, ManagementStrategy.class, arg_0 -> ((CamelContext)camelContext).setManagementStrategy(arg_0));
        MainSupport.registerPropertyForBeanType(registry, ManagementObjectNameStrategy.class, arg_0 -> ((ManagementStrategy)managementStrategy).setManagementObjectNameStrategy(arg_0));
        MainSupport.registerPropertyForBeanType(registry, EventFactory.class, arg_0 -> ((ManagementStrategy)managementStrategy).setEventFactory(arg_0));
        MainSupport.registerPropertyForBeanType(registry, UnitOfWorkFactory.class, arg_0 -> ((ExtendedCamelContext)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class))).setUnitOfWorkFactory(arg_0));
        MainSupport.registerPropertyForBeanType(registry, RuntimeEndpointRegistry.class, arg_0 -> ((CamelContext)camelContext).setRuntimeEndpointRegistry(arg_0));
        MainSupport.registerPropertiesForBeanTypes(registry, TypeConverters.class, arg_0 -> ((TypeConverterRegistry)camelContext.getTypeConverterRegistry()).addTypeConverters(arg_0));
        Predicate<EventNotifier> containsEventNotifier = managementStrategy.getEventNotifiers()::contains;
        MainSupport.registerPropertiesForBeanTypesWithCondition(registry, EventNotifier.class, containsEventNotifier.negate(), arg_0 -> ((ManagementStrategy)managementStrategy).addEventNotifier(arg_0));
        MainSupport.registerPropertiesForBeanTypes(registry, EndpointStrategy.class, arg_0 -> ((ExtendedCamelContext)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class))).registerEndpointCallback(arg_0));
        MainSupport.registerPropertyForBeanType(registry, ShutdownStrategy.class, arg_0 -> ((CamelContext)camelContext).setShutdownStrategy(arg_0));
        Predicate<InterceptStrategy> containsInterceptStrategy = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getInterceptStrategies()::contains;
        MainSupport.registerPropertiesForBeanTypesWithCondition(registry, InterceptStrategy.class, containsInterceptStrategy.negate(), arg_0 -> ((ExtendedCamelContext)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class))).addInterceptStrategy(arg_0));
        Predicate<LifecycleStrategy> containsLifecycleStrategy = camelContext.getLifecycleStrategies()::contains;
        MainSupport.registerPropertiesForBeanTypesWithCondition(registry, LifecycleStrategy.class, containsLifecycleStrategy.negate(), arg_0 -> ((CamelContext)camelContext).addLifecycleStrategy(arg_0));
        MainSupport.registerPropertiesForBeanTypes(registry, CamelClusterService.class, MainSupport.addServiceToContext(camelContext));
        Map serviceRegistries = registry.findByTypeWithName(ServiceRegistry.class);
        if (serviceRegistries != null && !serviceRegistries.isEmpty()) {
            for (Map.Entry entry : serviceRegistries.entrySet()) {
                ServiceRegistry service = (ServiceRegistry)entry.getValue();
                if (service.getId() == null) {
                    service.setId(camelContext.getUuidGenerator().generateUuid());
                }
                LOG.info("Using ServiceRegistry with id: {} and implementation: {}", (Object)service.getId(), (Object)service);
                camelContext.addService((Object)service);
            }
        }
        MainSupport.registerPropertiesForBeanTypes(registry, RoutePolicyFactory.class, arg_0 -> ((CamelContext)camelContext).addRoutePolicyFactory(arg_0));
        GlobalSSLContextParametersSupplier sslContextParametersSupplier = MainSupport.getSingleBeanOfType(registry, GlobalSSLContextParametersSupplier.class);
        if (sslContextParametersSupplier != null) {
            camelContext.setSSLContextParameters((SSLContextParameters)sslContextParametersSupplier.get());
        }
        if ((healthCheckRegistry = MainSupport.getSingleBeanOfType(registry, HealthCheckRegistry.class)) != null) {
            healthCheckRegistry.setCamelContext(camelContext);
            LOG.info("Using HealthCheckRegistry: {}", (Object)healthCheckRegistry);
            camelContext.setExtension(HealthCheckRegistry.class, (Object)healthCheckRegistry);
        } else {
            healthCheckRegistry = HealthCheckRegistry.get((CamelContext)camelContext);
            healthCheckRegistry.setCamelContext(camelContext);
        }
        MainSupport.registerPropertiesForBeanTypes(registry, HealthCheckRepository.class, arg_0 -> ((HealthCheckRegistry)healthCheckRegistry).addRepository(arg_0));
        MainSupport.registerPropertyForBeanType(registry, HealthCheckService.class, MainSupport.addServiceToContext(camelContext));
        MainSupport.registerPropertyForBeanType(registry, RouteController.class, arg_0 -> ((CamelContext)camelContext).setRouteController(arg_0));
        MainSupport.registerPropertyForBeanType(registry, UuidGenerator.class, arg_0 -> ((CamelContext)camelContext).setUuidGenerator(arg_0));
        Predicate<LogListener> containsLogListener = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getLogListeners()::contains;
        MainSupport.registerPropertiesForBeanTypesWithCondition(registry, LogListener.class, containsLogListener.negate(), arg_0 -> ((ExtendedCamelContext)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class))).addLogListener(arg_0));
        MainSupport.registerPropertyForBeanType(registry, ExecutorServiceManager.class, arg_0 -> ((CamelContext)camelContext).setExecutorServiceManager(arg_0));
        MainSupport.initThreadPoolProfiles(registry, camelContext);
    }

    private static void initThreadPoolProfiles(Registry registry, CamelContext camelContext) {
        HashSet defaultIds = new HashSet();
        Map profiles = registry.findByTypeWithName(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry entry : profiles.entrySet()) {
                ThreadPoolProfile profile = (ThreadPoolProfile)entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", entry.getKey(), (Object)profile);
                    camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                camelContext.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }

    private static <T> void registerPropertyForBeanType(Registry registry, Class<T> beanType, Consumer<T> propertySetter) {
        T propertyBean = MainSupport.getSingleBeanOfType(registry, beanType);
        if (propertyBean == null) {
            return;
        }
        LOG.info("Using custom {}: {}", (Object)beanType.getSimpleName(), propertyBean);
        propertySetter.accept(propertyBean);
    }

    private static <T> T getSingleBeanOfType(Registry registry, Class<T> type) {
        Map beans = registry.findByTypeWithName(type);
        if (beans.size() == 1) {
            return (T)beans.values().iterator().next();
        }
        return null;
    }

    private static <T> void registerPropertiesForBeanTypes(Registry registry, Class<T> beanType, Consumer<T> propertySetter) {
        MainSupport.registerPropertiesForBeanTypesWithCondition(registry, beanType, b -> true, propertySetter);
    }

    private static <T> void registerPropertiesForBeanTypesWithCondition(Registry registry, Class<T> beanType, Predicate<T> condition, Consumer<T> propertySetter) {
        Map beans = registry.findByTypeWithName(beanType);
        if (!org.apache.camel.util.ObjectHelper.isNotEmpty((Object)beans)) {
            return;
        }
        String simpleName = beanType.getSimpleName();
        beans.forEach((name, bean) -> {
            if (condition.test(bean)) {
                LOG.info("Adding custom {} with id: {} and implementation: {}", new Object[]{simpleName, name, bean});
                propertySetter.accept(bean);
            }
        });
    }

    private static <T> Consumer<T> addServiceToContext(CamelContext camelContext) {
        return service -> {
            try {
                camelContext.addService(service);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to add service to Camel context", e);
            }
        };
    }

    protected void autoConfigurationPropertiesComponent(CamelContext camelContext) throws Exception {
        Properties prop = camelContext.getPropertiesComponent().loadProperties();
        LinkedHashMap<PropertiesComponent, Map> properties = new LinkedHashMap<PropertiesComponent, Map>();
        for (String key : prop.stringPropertyNames()) {
            int dot = key.indexOf(".", 26);
            if (!key.startsWith("camel.component.properties.") || dot <= 0) continue;
            PropertiesComponent component = camelContext.getPropertiesComponent();
            String value = prop.getProperty(key);
            String option = key.substring(dot + 1);
            Map values = properties.getOrDefault(component, new LinkedHashMap());
            values.put(option, value);
            properties.put(component, values);
        }
        if (!properties.isEmpty()) {
            long total = properties.values().stream().mapToLong(Map::size).sum();
            LOG.info("Auto configuring properties component from loaded properties: {}", (Object)total);
        }
        for (String obj : properties.keySet()) {
            Map values = (Map)properties.get(obj);
            MainSupport.setCamelProperties(camelContext, obj, values, true);
        }
    }

    protected void autoConfigurationMainConfiguration(CamelContext camelContext, MainConfigurationProperties config) throws Exception {
        Properties prop = camelContext.getPropertiesComponent().loadProperties();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.main.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(11);
            properties.put(option, value);
        }
        if (!properties.isEmpty()) {
            LOG.info("Auto configuring main from loaded properties: {}", (Object)properties.size());
        }
        MainSupport.setCamelProperties(camelContext, config, properties, true);
    }

    protected void autoConfigurationFromProperties(CamelContext camelContext) throws Exception {
        Properties prop = camelContext.getPropertiesComponent().loadProperties();
        LinkedHashMap<Object, Map> properties = new LinkedHashMap<Object, Map>();
        for (String key : prop.stringPropertyNames()) {
            Map values;
            String option;
            String value;
            String name;
            int dot = key.indexOf(".", 16);
            if (key.startsWith("camel.component.") && dot > 0) {
                name = key.substring(16, dot);
                if ("properties".equals(name)) continue;
                Component component = camelContext.getComponent(name);
                value = prop.getProperty(key);
                option = key.substring(dot + 1);
                values = properties.getOrDefault(component, new LinkedHashMap());
                values.put(option, value);
                properties.put(component, values);
            }
            dot = key.indexOf(".", 17);
            if (key.startsWith("camel.dataformat.") && dot > 0) {
                name = key.substring(17, dot);
                DataFormat dataformat = camelContext.resolveDataFormat(name);
                value = prop.getProperty(key);
                option = key.substring(dot + 1);
                values = properties.getOrDefault(dataformat, new LinkedHashMap());
                values.put(option, value);
                properties.put(dataformat, values);
            }
            dot = key.indexOf(".", 15);
            if (!key.startsWith("camel.language.") || dot <= 0) continue;
            name = key.substring(15, dot);
            Language language = camelContext.resolveLanguage(name);
            value = prop.getProperty(key);
            option = key.substring(dot + 1);
            values = properties.getOrDefault(language, new LinkedHashMap());
            values.put(option, value);
            properties.put(language, values);
        }
        if (!properties.isEmpty()) {
            long total = properties.values().stream().mapToLong(Map::size).sum();
            LOG.info("Auto configuring {} components/dataformat/languages from loaded properties: {}", (Object)properties.size(), (Object)total);
        }
        for (String obj : properties.keySet()) {
            Map values = (Map)properties.get(obj);
            MainSupport.setCamelProperties(camelContext, obj, values, true);
        }
    }

    protected void autoConfigurationFromRegistry(final CamelContext camelContext, final boolean deepNesting) throws Exception {
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                PropertyBindingSupport.autowireSingletonPropertiesFromRegistry((CamelContext)camelContext, (Object)component, (boolean)false, (boolean)deepNesting, (obj, propertyName, type, value) -> LOG.info("Auto configuring option: {} on component: {} as one instance of type: {} registered in the Camel Registry", new Object[]{propertyName, component.getClass().getSimpleName(), type.getName()}));
            }
        });
    }

    public void addRouteBuilder(RouteBuilder routeBuilder) {
        this.getRouteBuilders().add(routeBuilder);
    }

    public void addRouteBuilder(Class ... routeBuilder) {
        String existing = this.routeBuilderClasses;
        if (existing == null) {
            existing = "";
        }
        if (routeBuilder != null) {
            for (Class clazz : routeBuilder) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setRouteBuilderClasses(existing);
    }

    private static boolean setCamelProperties(CamelContext context, Object target, Map<String, Object> properties, boolean failIfNotSet) throws Exception {
        org.apache.camel.util.ObjectHelper.notNull((Object)context, (String)"context");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object value = entry.getValue();
            String stringValue = value != null ? value.toString() : null;
            LOG.debug("Setting property {} on {} with value {}", new Object[]{name, target, stringValue});
            boolean hit = PropertyBindingSupport.bindProperty((CamelContext)context, (Object)target, (String)name, (Object)stringValue);
            if (hit) {
                it.remove();
                rc = true;
                continue;
            }
            if (!failIfNotSet) continue;
            throw new IllegalArgumentException("Cannot configure option [" + name + "] with value [" + stringValue + "] as the bean class [" + org.apache.camel.util.ObjectHelper.classCanonicalName((Object)target) + "] has no suitable setter method, or not possible to lookup a bean with the id [" + stringValue + "] in Camel registry");
        }
        return rc;
    }

    private static /* synthetic */ boolean lambda$doConfigureCamelContextFromMainConfiguration$0(String pattern, File f) {
        return StringHelper.matches((String)pattern, (String)f.getName());
    }

    public abstract class ParameterOption
    extends Option {
        private String parameterName;

        protected ParameterOption(String abbreviation, String fullName, String description, String parameterName) {
            super(abbreviation, fullName, description);
            this.parameterName = parameterName;
        }

        @Override
        protected void doProcess(String arg, LinkedList<String> remainingArgs) {
            if (remainingArgs.isEmpty()) {
                System.err.println("Expected fileName for ");
                MainSupport.this.showOptions();
                MainSupport.this.completed();
            } else {
                String parameter = remainingArgs.removeFirst();
                this.doProcess(arg, parameter, remainingArgs);
            }
        }

        @Override
        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " <" + this.parameterName + "> = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, String var2, LinkedList<String> var3);
    }

    public abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }

    private static final class HangupInterceptor
    extends Thread {
        Logger log = LoggerFactory.getLogger(this.getClass());
        final MainSupport mainInstance;

        HangupInterceptor(MainSupport main) {
            this.mainInstance = main;
        }

        @Override
        public void run() {
            this.log.info("Received hang up - stopping the main instance.");
            try {
                this.mainInstance.stop();
            }
            catch (Exception ex) {
                this.log.warn("Error during stopping the main instance.", (Throwable)ex);
            }
        }
    }
}

