/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.flatpack.DataSet;
import org.apache.camel.Converter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Converter(loader=true)
public final class FlatpackConverter {
    private FlatpackConverter() {
    }

    @Converter
    public static Map<String, Object> toMap(DataSet dataSet) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FlatpackConverter.putValues(map, dataSet);
        return map;
    }

    @Converter
    public static List<Map<String, Object>> toList(DataSet dataSet) {
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        dataSet.goTop();
        while (dataSet.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            FlatpackConverter.putValues(map, dataSet);
            answer.add(map);
        }
        return answer;
    }

    @Converter
    public static Document toDocument(DataSet dataSet) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        Document doc = dbf.newDocumentBuilder().newDocument();
        if (dataSet.getIndex() == -1) {
            Element list = doc.createElement("Dataset");
            dataSet.goTop();
            while (dataSet.next()) {
                list.appendChild(FlatpackConverter.createDatasetRecord(dataSet, doc));
            }
            doc.appendChild(list);
        } else {
            doc.appendChild(FlatpackConverter.createDatasetRecord(dataSet, doc));
        }
        return doc;
    }

    private static void putValues(Map<String, Object> map, DataSet dataSet) {
        String[] columns;
        for (String column : columns = FlatpackConverter.getColumns(dataSet)) {
            String value = dataSet.getString(column);
            map.put(column, value);
        }
    }

    private static Element createDatasetRecord(DataSet dataSet, Document doc) {
        String[] columns;
        Element record = dataSet.isRecordID("header") ? doc.createElement("DatasetHeader") : (dataSet.isRecordID("trailer") ? doc.createElement("DatasetTrailer") : doc.createElement("DatasetRecord"));
        for (String column : columns = FlatpackConverter.getColumns(dataSet)) {
            String value = dataSet.getString(column);
            Element columnElement = doc.createElement("Column");
            columnElement.setAttribute("name", column);
            columnElement.setTextContent(value);
            record.appendChild(columnElement);
        }
        return record;
    }

    private static String[] getColumns(DataSet dataSet) {
        if (dataSet.isRecordID("header")) {
            return dataSet.getColumns("header");
        }
        if (dataSet.isRecordID("trailer")) {
            return dataSet.getColumns("trailer");
        }
        return dataSet.getColumns();
    }
}

