/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.client;

import io.grpc.stub.StreamObserver;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public class GrpcResponseRouterStreamObserver
extends ServiceSupport
implements StreamObserver<Object> {
    private final Endpoint sourceEndpoint;
    private final GrpcConfiguration configuration;
    private Endpoint endpoint;
    private AsyncProducer producer;

    public GrpcResponseRouterStreamObserver(GrpcConfiguration configuration, Endpoint sourceEndpoint) throws Exception {
        this.configuration = configuration;
        this.sourceEndpoint = sourceEndpoint;
    }

    public void onNext(Object o) {
        Exchange exchange = this.sourceEndpoint.createExchange();
        exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onNext");
        exchange.getIn().setBody(o);
        this.doSend(exchange);
    }

    public void onError(Throwable throwable) {
        if (this.configuration.isForwardOnError()) {
            Exchange exchange = this.sourceEndpoint.createExchange();
            exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onError");
            exchange.getIn().setBody((Object)throwable);
            this.doSend(exchange);
        }
    }

    public void onCompleted() {
        if (this.configuration.isForwardOnCompleted()) {
            Exchange exchange = this.sourceEndpoint.createExchange();
            exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onCompleted");
            this.doSend(exchange);
        }
    }

    private void doSend(Exchange exchange) {
        this.producer.processAsync(exchange);
    }

    protected void doStart() throws Exception {
        this.endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)this.sourceEndpoint.getCamelContext(), (String)this.configuration.getStreamRepliesTo());
        this.producer = this.endpoint.createAsyncProducer();
        ServiceHelper.startService((Object)this.producer);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producer);
    }
}

