/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.util.IOHelper;

public class DefaultPropertiesResolver
implements PropertiesResolver {
    private final PropertiesComponent propertiesComponent;

    public DefaultPropertiesResolver(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    @Override
    public Properties resolveProperties(CamelContext context, boolean ignoreMissingLocation, List<PropertiesLocation> locations) {
        Properties answer = new Properties();
        block9: for (PropertiesLocation location : locations) {
            Properties prop;
            switch (location.getResolver()) {
                case "ref": {
                    prop = this.loadPropertiesFromRegistry(context, ignoreMissingLocation, location);
                    prop = this.prepareLoadedProperties(prop);
                    answer.putAll((Map<?, ?>)prop);
                    continue block9;
                }
                case "file": {
                    prop = this.loadPropertiesFromFilePath(context, ignoreMissingLocation, location);
                    prop = this.prepareLoadedProperties(prop);
                    answer.putAll((Map<?, ?>)prop);
                    continue block9;
                }
            }
            prop = this.loadPropertiesFromClasspath(context, ignoreMissingLocation, location);
            prop = this.prepareLoadedProperties(prop);
            answer.putAll((Map<?, ?>)prop);
        }
        return answer;
    }

    /*
     * Loose catch block
     */
    protected Properties loadPropertiesFromFilePath(CamelContext context, boolean ignoreMissingLocation, PropertiesLocation location) {
        BufferedReader reader;
        FileInputStream is;
        Properties answer;
        block7: {
            answer = new Properties();
            String path = location.getPath();
            is = null;
            reader = null;
            try {
                is = new FileInputStream(path);
                if (this.propertiesComponent.getEncoding() != null) {
                    reader = new BufferedReader(new InputStreamReader((InputStream)is, this.propertiesComponent.getEncoding()));
                    answer.load(reader);
                    break block7;
                }
                answer.load(is);
            }
            catch (FileNotFoundException e) {
                block8: {
                    if (ignoreMissingLocation || location.isOptional()) break block8;
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
                IOHelper.close((Closeable[])new Closeable[]{reader, is});
            }
            catch (IOException e2) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOHelper.close((Closeable[])new Closeable[]{reader, is});
                        throw throwable;
                    }
                }
            }
        }
        IOHelper.close((Closeable[])new Closeable[]{reader, is});
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties loadPropertiesFromClasspath(CamelContext context, boolean ignoreMissingLocation, PropertiesLocation location) {
        BufferedReader reader;
        InputStream is;
        Properties answer;
        block6: {
            answer = new Properties();
            String path = location.getPath();
            is = context.getClassResolver().loadResourceAsStream(path);
            reader = null;
            if (is == null) {
                if (ignoreMissingLocation || location.isOptional()) return answer;
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)new FileNotFoundException("Properties file " + path + " not found in classpath"));
            }
            try {
                if (this.propertiesComponent.getEncoding() != null) {
                    reader = new BufferedReader(new InputStreamReader(is, this.propertiesComponent.getEncoding()));
                    answer.load(reader);
                    break block6;
                }
                answer.load(is);
            }
            catch (IOException e) {
                try {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOHelper.close((Closeable[])new Closeable[]{reader, is});
                    throw throwable;
                }
            }
        }
        IOHelper.close((Closeable[])new Closeable[]{reader, is});
        return answer;
    }

    protected Properties loadPropertiesFromRegistry(CamelContext context, boolean ignoreMissingLocation, PropertiesLocation location) {
        Properties answer;
        String path = location.getPath();
        try {
            answer = (Properties)context.getRegistry().lookupByNameAndType(path, Properties.class);
        }
        catch (Exception ex) {
            Map map = (Map)context.getRegistry().lookupByNameAndType(path, Map.class);
            answer = new Properties();
            answer.putAll((Map<?, ?>)map);
        }
        if (answer == null && !ignoreMissingLocation && !location.isOptional()) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)new FileNotFoundException("Properties " + path + " not found in registry"));
        }
        return answer != null ? answer : new Properties();
    }

    protected Properties prepareLoadedProperties(Properties properties) {
        Properties answer = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String s = (String)value;
                value = DefaultPropertiesResolver.trimTrailingWhitespaces(s);
            }
            answer.put(key, value);
        }
        return answer;
    }

    private static String trimTrailingWhitespaces(String s) {
        int endIndex = s.length();
        int index = s.length() - 1;
        while (index >= 0 && s.charAt(index) == ' ') {
            endIndex = index--;
        }
        String answer = s.substring(0, endIndex);
        return answer;
    }
}

