/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.queue;

import com.microsoft.azure.storage.StorageException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.component.azure.queue.QueueServiceConfiguration;
import org.apache.camel.component.azure.queue.QueueServiceEndpoint;
import org.apache.camel.component.azure.queue.QueueServiceUtil;
import org.apache.camel.support.ScheduledPollConsumer;

public class QueueServiceConsumer
extends ScheduledPollConsumer {
    public QueueServiceConsumer(QueueServiceEndpoint endpoint, Processor processor) throws NoFactoryAvailableException {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        Exchange exchange = super.getEndpoint().createExchange();
        try {
            this.log.trace("Retrieving a message");
            this.retrieveMessage(exchange);
            super.getAsyncProcessor().process(exchange);
            return 1;
        }
        catch (StorageException ex) {
            if (404 == ex.getHttpStatusCode()) {
                return 0;
            }
            throw ex;
        }
    }

    private void retrieveMessage(Exchange exchange) throws Exception {
        QueueServiceUtil.retrieveMessage(exchange, this.getConfiguration());
    }

    protected QueueServiceConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public QueueServiceEndpoint getEndpoint() {
        return (QueueServiceEndpoint)super.getEndpoint();
    }
}

