/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nsq;

import com.github.brainlag.nsq.NSQProducer;
import com.github.brainlag.nsq.ServerAddress;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.nsq.NsqConfiguration;
import org.apache.camel.component.nsq.NsqEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NsqProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NsqProducer.class);
    private NSQProducer producer;
    private final NsqConfiguration configuration;

    public NsqProducer(NsqEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getNsqConfiguration();
    }

    public NsqEndpoint getEndpoint() {
        return (NsqEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String topic = (String)exchange.getIn().getHeader("CamelNsqMessageTopic", (Object)this.configuration.getTopic(), String.class);
        LOG.debug("Publishing to topic: {}", (Object)topic);
        byte[] body = (byte[])exchange.getIn().getBody(byte[].class);
        this.producer.produce(topic, body);
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Starting NSQ Producer");
        NsqConfiguration config = this.getEndpoint().getNsqConfiguration();
        this.producer = new NSQProducer();
        for (ServerAddress server : config.getServerAddresses()) {
            this.producer.addAddress(server.getHost(), server.getPort() == 0 ? config.getPort() : server.getPort());
        }
        this.producer.setConfig(this.getEndpoint().getNsqConfig());
        this.producer.start();
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping NSQ Producer");
        if (this.producer != null) {
            this.producer.shutdown();
        }
        super.doStop();
    }
}

