/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet.converter;

import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.restlet.converter.RestletConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.restlet.data.MediaType;
import org.restlet.data.Method;

public class RestletConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, MediaType.class, String.class, false, (type, exchange, value) -> RestletConverter.toMediaType((String)value));
        this.addTypeConverter(registry, MediaType[].class, String.class, false, (type, exchange, value) -> RestletConverter.toMediaTypes((String)value));
        this.addTypeConverter(registry, Method.class, String.class, false, (type, exchange, value) -> RestletConverter.toMethod((String)value));
        this.addTypeConverter(registry, Method[].class, String.class, false, (type, exchange, value) -> RestletConverter.toMethods((String)value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

