/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.io.IOException;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletComponent;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.component.restlet.RestletOperationException;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.URISupport;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Parameter;
import org.restlet.engine.ssl.SslContextFactory;
import org.restlet.util.Series;

public class RestletProducer
extends DefaultAsyncProducer {
    private static final Pattern PATTERN = Pattern.compile("\\{([\\w\\.]*)\\}");
    private Client client;
    private boolean throwException;

    public RestletProducer(RestletEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.client = new Client(endpoint.getProtocol());
        Context context = new Context();
        Series parameters = context.getParameters();
        parameters.add("socketTimeout", String.valueOf(endpoint.getSocketTimeout()));
        parameters.add("socketConnectTimeoutMs", String.valueOf(endpoint.getSocketTimeout()));
        RestletComponent component = (RestletComponent)endpoint.getComponent();
        if (component.getMaxConnectionsPerHost() != null && component.getMaxConnectionsPerHost() > 0) {
            parameters.add("maxConnectionsPerHost", String.valueOf(component.getMaxConnectionsPerHost()));
        }
        if (component.getMaxTotalConnections() != null && component.getMaxTotalConnections() > 0) {
            parameters.add("maxTotalConnections", String.valueOf(component.getMaxTotalConnections()));
        }
        ConcurrentMap attributes = context.getAttributes();
        CamelContext camelContext = endpoint.getCamelContext();
        SSLContextParameters sslContextParameters = endpoint.getSslContextParameters();
        if (sslContextParameters != null) {
            SSLContext sslContext = sslContextParameters.createSSLContext(camelContext);
            attributes.put("sslContextFactory", new PredefinedSslContextFactory(sslContext));
        }
        this.client.setContext(context);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client.start();
    }

    public void doStop() throws Exception {
        this.client.stop();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        RestletEndpoint endpoint = (RestletEndpoint)this.getEndpoint();
        RestletBinding binding = endpoint.getRestletBinding();
        String resourceUri = this.buildUri(endpoint, exchange);
        URI uri = new URI(resourceUri);
        Request request = new Request(endpoint.getRestletMethod(), resourceUri);
        binding.populateRestletRequestFromExchange(request, exchange);
        this.loadCookies(exchange, uri, request);
        this.log.debug("Sending request synchronously: {} for exchangeId: {}", (Object)request, (Object)exchange.getExchangeId());
        Response response = this.client.handle(request);
        this.log.debug("Received response synchronously: {} for exchangeId: {}", (Object)response, (Object)exchange.getExchangeId());
        if (response != null) {
            Integer respCode = response.getStatus().getCode();
            this.storeCookies(exchange, uri, response);
            if (respCode > 207 && this.throwException) {
                exchange.setException((Throwable)((Object)this.populateRestletProducerException(exchange, response, respCode)));
            } else {
                binding.populateExchangeFromRestletResponse(exchange, response);
            }
        }
    }

    private void storeCookies(Exchange exchange, URI uri, Response response) {
        RestletEndpoint endpoint = (RestletEndpoint)this.getEndpoint();
        if (endpoint.getCookieHandler() != null) {
            Series cookieSettings = response.getCookieSettings();
            CookieStore cookieJar = endpoint.getCookieHandler().getCookieStore(exchange);
            for (CookieSetting s : cookieSettings) {
                HttpCookie cookie = new HttpCookie(s.getName(), s.getValue());
                cookie.setComment(s.getComment());
                cookie.setDomain(s.getDomain());
                cookie.setMaxAge(s.getMaxAge());
                cookie.setPath(s.getPath());
                cookie.setSecure(s.isSecure());
                cookie.setVersion(s.getVersion());
                cookieJar.add(uri, cookie);
            }
        }
    }

    private void loadCookies(Exchange exchange, URI uri, Request request) throws IOException {
        RestletEndpoint endpoint = (RestletEndpoint)this.getEndpoint();
        if (endpoint.getCookieHandler() != null) {
            Series cookies = request.getCookies();
            Map cookieHeaders = endpoint.getCookieHandler().loadCookies(exchange, uri);
            for (String cookieHeader : cookieHeaders.keySet()) {
                for (String cookieStr : (List)cookieHeaders.get(cookieHeader)) {
                    for (HttpCookie cookie : HttpCookie.parse(cookieStr)) {
                        cookies.add((Object)new Cookie(cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain()));
                    }
                }
            }
        }
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Request request;
        final RestletEndpoint endpoint = (RestletEndpoint)this.getEndpoint();
        if (endpoint.isSynchronous()) {
            try {
                this.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        this.log.trace("Processing asynchronously");
        final RestletBinding binding = endpoint.getRestletBinding();
        try {
            String resourceUri = this.buildUri(endpoint, exchange);
            URI uri = new URI(resourceUri);
            request = new Request(endpoint.getRestletMethod(), resourceUri);
            binding.populateRestletRequestFromExchange(request, exchange);
            this.loadCookies(exchange, uri, request);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        this.log.debug("Sending request asynchronously: {} for exchangeId: {}", (Object)request, (Object)exchange.getExchangeId());
        this.client.handle(request, new Uniform(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Request request, Response response) {
                RestletProducer.this.log.debug("Received response asynchronously: {} for exchangeId: {}", (Object)response, (Object)exchange.getExchangeId());
                try {
                    if (response != null) {
                        String resourceUri = RestletProducer.this.buildUri(endpoint, exchange);
                        URI uri = new URI(resourceUri);
                        Integer respCode = response.getStatus().getCode();
                        RestletProducer.this.storeCookies(exchange, uri, response);
                        if (respCode > 207 && RestletProducer.this.throwException) {
                            exchange.setException((Throwable)((Object)RestletProducer.this.populateRestletProducerException(exchange, response, respCode)));
                        } else {
                            binding.populateExchangeFromRestletResponse(exchange, response);
                        }
                    }
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                finally {
                    callback.done(false);
                }
            }
        });
        return false;
    }

    private String buildUri(RestletEndpoint endpoint, Exchange exchange) throws Exception {
        String query;
        String uri = (String)exchange.getIn().removeHeader("CamelRestHttpUri");
        if (uri == null) {
            uri = endpoint.getProtocol() + "://" + endpoint.getHost() + ":" + endpoint.getPort() + endpoint.getUriPattern();
        }
        this.log.trace("Substituting '{value}' placeholders in uri: {}", (Object)uri);
        Matcher matcher = PATTERN.matcher(uri);
        while (matcher.find()) {
            String key = matcher.group(1);
            String header = (String)exchange.getIn().getHeader(key, String.class);
            if (header == null) {
                throw new CamelExchangeException("Header with key: " + key + " not found in Exchange", exchange);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Replacing: {} with header value: {}", (Object)matcher.group(0), (Object)header);
            }
            uri = matcher.replaceFirst(header);
            matcher.reset(uri);
        }
        if (endpoint.getQueryParameters() != null) {
            uri = URISupport.appendParametersToURI((String)uri, endpoint.getQueryParameters());
        }
        if ((query = (String)exchange.getIn().removeHeader("CamelRestHttpQuery")) == null) {
            query = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        }
        if (query != null) {
            this.log.trace("Adding query: {} to uri: {}", (Object)query, (Object)uri);
            uri = RestletProducer.addQueryToUri(uri, query);
        }
        this.log.trace("Using uri: {}", (Object)uri);
        return uri;
    }

    protected static String addQueryToUri(String uri, String query) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        StringBuilder answer = new StringBuilder();
        int index = uri.indexOf(63);
        if (index < 0) {
            answer.append(uri);
            answer.append("?");
            answer.append(query);
        } else {
            answer.append(uri.substring(0, index));
            answer.append("?");
            answer.append(query);
            String remaining = uri.substring(index + 1);
            if (remaining.length() > 0) {
                answer.append("&");
                answer.append(remaining);
            }
        }
        return answer.toString();
    }

    protected RestletOperationException populateRestletProducerException(Exchange exchange, Response response, int responseCode) {
        RestletOperationException exception;
        String copy;
        String uri = response.getRequest().getResourceRef().toString();
        String statusText = response.getStatus().getDescription();
        Map<String, String> headers = this.parseResponseHeaders(response, exchange);
        if (response.getEntity() != null) {
            try {
                copy = response.getEntity().getText();
            }
            catch (Exception ex) {
                copy = ex.toString();
            }
        } else {
            copy = response.toString();
        }
        if (responseCode >= 300 && responseCode < 400) {
            if (response.getStatus().isRedirection()) {
                String redirectLocation = response.getLocationRef().getHostIdentifier();
                exception = new RestletOperationException(uri, responseCode, statusText, redirectLocation, headers, copy);
            } else {
                exception = new RestletOperationException(uri, responseCode, statusText, null, headers, copy);
            }
        } else {
            exception = new RestletOperationException(uri, responseCode, statusText, null, headers, copy);
        }
        return exception;
    }

    protected Map<String, String> parseResponseHeaders(Object response, Exchange camelExchange) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (response instanceof Response) {
            for (Map.Entry entry : ((Response)response).getAttributes().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.log.trace("Parse external header {}={}", (Object)key, value);
                answer.put(key, value.toString());
            }
        }
        return answer;
    }

    private static final class PredefinedSslContextFactory
    extends SslContextFactory {
        private final SSLContext sslContext;

        private PredefinedSslContextFactory(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        public void init(Series<Parameter> parameters) {
        }

        public SSLContext createSslContext() throws Exception {
            return this.sslContext;
        }
    }
}

