/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.crypto.cms.CryptoCmsComponent;
import org.apache.camel.component.crypto.cms.CryptoCmsProducer;
import org.apache.camel.component.crypto.cms.CryptoOperation;
import org.apache.camel.component.crypto.cms.crypt.DefaultEnvelopedDataDecryptorConfiguration;
import org.apache.camel.component.crypto.cms.crypt.EnvelopedDataEncryptorConfiguration;
import org.apache.camel.component.crypto.cms.sig.DefaultSignedDataVerifierConfiguration;
import org.apache.camel.component.crypto.cms.sig.SignedDataCreatorConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.20.0", scheme="crypto-cms", title="Crypto CMS", syntax="crypto-cms:cryptoOperation:name", producerOnly=true, label="security,transformation")
public class CryptoCmsEndpoint
extends DefaultEndpoint {
    private final Processor processor;
    @UriPath
    @Metadata(required=true)
    private CryptoOperation cryptoOperation;
    @UriPath
    @Metadata(required=true)
    private String name;
    @UriParam
    private SignedDataCreatorConfiguration signConfig;
    @UriParam
    private DefaultSignedDataVerifierConfiguration verifyConfig;
    @UriParam
    private EnvelopedDataEncryptorConfiguration encryptConfig;
    @UriParam
    private DefaultEnvelopedDataDecryptorConfiguration decryptConfig;

    public CryptoCmsEndpoint(String uri, CryptoCmsComponent component, Processor processor) {
        super(uri, (Component)component);
        this.processor = processor;
    }

    public String getName() {
        return this.name;
    }

    public void setCryptoOperation(String operation) {
        this.cryptoOperation = CryptoOperation.valueOf(operation);
    }

    public void setCryptoOperation(CryptoOperation operation) {
        this.cryptoOperation = operation;
    }

    public CryptoOperation getCryptoOperation() {
        return this.cryptoOperation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Producer createProducer() {
        return new CryptoCmsProducer((Endpoint)this, this.processor);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Crypto CMS endpoints are not meant to be consumed from. They are meant be used as intermediate endpoints");
    }

    public Object getManagedObject(CryptoCmsEndpoint endpoint) {
        return this;
    }
}

