/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import org.apache.camel.Message;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.query.dsl.Query;

public final class InfinispanRemoteOperation {
    private InfinispanRemoteOperation() {
    }

    public static Query buildQuery(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
        InfinispanQueryBuilder queryBuilder = (InfinispanQueryBuilder)message.getHeader("CamelInfinispanQueryBuilder", InfinispanQueryBuilder.class);
        if (queryBuilder == null) {
            queryBuilder = configuration.getQueryBuilder();
        }
        return InfinispanRemoteOperation.buildQuery(queryBuilder, cache);
    }

    public static Query buildQuery(InfinispanConfiguration configuration, BasicCache<Object, Object> cache) {
        return InfinispanRemoteOperation.buildQuery(configuration.getQueryBuilder(), cache);
    }

    public static Query buildQuery(InfinispanQueryBuilder queryBuilder, BasicCache<Object, Object> cache) {
        return InfinispanRemoteOperation.buildQuery(queryBuilder, InfinispanUtil.asRemote(cache));
    }

    public static Query buildQuery(InfinispanQueryBuilder queryBuilder, RemoteCache<Object, Object> cache) {
        return queryBuilder != null ? queryBuilder.build(Search.getQueryFactory(cache)) : null;
    }
}

