/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.component.soroushbot.utils.PoolWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiQueueWithTopicThreadPool {
    private static Logger log = LoggerFactory.getLogger(MultiQueueWithTopicThreadPool.class);
    private boolean shutdown;
    private int poolSize;
    private List<PoolWorker> workers = new ArrayList<PoolWorker>();

    public MultiQueueWithTopicThreadPool(int poolSize, int capacity, String namePrefix) {
        if (log.isDebugEnabled()) {
            log.debug("creating MultiQueueWithTopicThreadPool with size " + poolSize + " and capacity of each queue is set to " + capacity);
        }
        this.poolSize = poolSize;
        for (int i = 0; i < poolSize; ++i) {
            PoolWorker e = new PoolWorker(capacity);
            this.workers.add(e);
            e.start();
            e.setName(namePrefix + " #" + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object topic, Runnable runnable) throws IllegalStateException {
        PoolWorker poolWorker;
        if (this.shutdown) {
            throw new RejectedExecutionException("pool has been shutdown");
        }
        int selectedQueue = topic instanceof Integer ? (Integer)topic % this.poolSize : topic.hashCode() % this.poolSize;
        PoolWorker poolWorker2 = poolWorker = this.workers.get(selectedQueue);
        synchronized (poolWorker2) {
            poolWorker.enqueue(runnable);
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

