/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.service;

import java.io.IOException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.camel.component.soroushbot.models.Endpoint;
import org.apache.camel.component.soroushbot.models.SoroushMessage;
import org.apache.camel.component.soroushbot.models.response.SoroushResponse;
import org.apache.camel.component.soroushbot.utils.SoroushException;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public final class SoroushService {
    private static final String URL = "https://bot.sapp.ir";
    private static SoroushService soroushService;
    private String alternativeUrl;

    private SoroushService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoroushService get() {
        if (soroushService != null) {
            return soroushService;
        }
        Class<SoroushService> clazz = SoroushService.class;
        synchronized (SoroushService.class) {
            if (soroushService != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return soroushService;
            }
            soroushService = new SoroushService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return soroushService;
        }
    }

    public String generateUrl(String token, Endpoint type, String fileId) {
        return this.getCurrentUrl() + "/" + token + "/" + type.value() + (fileId != null ? "/" + fileId : "");
    }

    private String getCurrentUrl() {
        if (this.alternativeUrl != null) {
            return this.alternativeUrl;
        }
        return URL;
    }

    public WebTarget createUploadFileTarget(String token, Integer timeOut) {
        return ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().property("jersey.config.client.connectTimeout", (Object)timeOut)).register(MultiPartFeature.class)).build().target(this.generateUrl(token, Endpoint.uploadFile, null));
    }

    public WebTarget createSendMessageTarget(String token, Integer timeOut) {
        return ((ClientBuilder)ClientBuilder.newBuilder().property("jersey.config.client.connectTimeout", (Object)timeOut)).build().target(this.generateUrl(token, Endpoint.sendMessage, null));
    }

    public WebTarget createDownloadFileTarget(String token, String fileId, Integer timeOut) {
        return ((ClientBuilder)ClientBuilder.newBuilder().property("jersey.config.client.connectTimeout", (Object)timeOut)).build().target(this.generateUrl(token, Endpoint.downloadFile, fileId));
    }

    public SoroushResponse assertSuccessful(Response response, SoroushMessage soroushMessage) throws IOException, SoroushException {
        return this.assertSuccessful(response, SoroushResponse.class, soroushMessage);
    }

    public <T> T assertSuccessful(Response response, Class<T> responseType, SoroushMessage soroushMessage) throws IOException, SoroushException {
        int status = response.getStatus();
        if (status == 503 || status == 429 || status == 301) {
            String message = (String)response.readEntity(String.class);
            throw new IOException("code: " + status + " message:" + message);
        }
        if (status >= 300) {
            throw new SoroushException(soroushMessage, null, status, (String)response.readEntity(String.class));
        }
        if (SoroushResponse.class.isAssignableFrom(responseType)) {
            Class<SoroushResponse> soroushResponseType = responseType.asSubclass(SoroushResponse.class);
            SoroushResponse soroushResponse = (SoroushResponse)response.readEntity(soroushResponseType);
            if (soroushResponse.getResultCode() != 200) {
                String body = soroushResponse.toString();
                throw new SoroushException(soroushMessage, soroushResponse, status, body);
            }
            return (T)soroushResponse;
        }
        return (T)response.readEntity(responseType);
    }

    public void setAlternativeUrl(String alternativeUrl) {
        this.alternativeUrl = alternativeUrl;
    }
}

