/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.component;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.soroushbot.component.SoroushBotEndpoint;
import org.apache.camel.component.soroushbot.models.SoroushMessage;
import org.apache.camel.component.soroushbot.service.SoroushService;
import org.apache.camel.component.soroushbot.utils.MaximumConnectionRetryReachedException;
import org.apache.camel.component.soroushbot.utils.SoroushException;
import org.apache.camel.component.soroushbot.utils.StringUtils;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoroushBotSendMessageProducer
extends DefaultProducer {
    private static Logger log = LoggerFactory.getLogger(SoroushBotSendMessageProducer.class);
    SoroushBotEndpoint endpoint;
    ObjectMapper objectMapper = new ObjectMapper();

    public SoroushBotSendMessageProducer(SoroushBotEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        SoroushMessage message = (SoroushMessage)exchange.getIn().getBody(SoroushMessage.class);
        if (this.endpoint.autoUploadFile.booleanValue()) {
            this.endpoint.handleFileUpload(message);
        }
        this.sendMessage(message);
    }

    private void sendMessage(SoroushMessage message) throws SoroushException, MaximumConnectionRetryReachedException, InterruptedException {
        for (int count = 0; count <= this.endpoint.maxConnectionRetry; ++count) {
            this.endpoint.waitBeforeRetry(count);
            try {
                if (log.isDebugEnabled()) {
                    log.debug("sending message for " + StringUtils.ordinal(count + 1) + " time(s). message:" + message);
                }
                Response response = this.endpoint.getSendMessageTarget().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)this.objectMapper.writeValueAsString((Object)message), (MediaType)MediaType.APPLICATION_JSON_TYPE));
                SoroushService.get().assertSuccessful(response, message);
                return;
            }
            catch (IOException | ProcessingException ex) {
                if (count == this.endpoint.maxConnectionRetry) {
                    throw new MaximumConnectionRetryReachedException("failed to send message. maximum retry limit reached. aborting... message: " + message, ex, message);
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("failed to send message: " + message, ex);
                continue;
            }
        }
    }
}

