/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.component;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.soroushbot.component.SoroushBotAbstractConsumer;
import org.apache.camel.component.soroushbot.component.SoroushBotEndpoint;
import org.apache.camel.component.soroushbot.models.SoroushMessage;
import org.apache.camel.component.soroushbot.utils.CongestionException;
import org.apache.camel.component.soroushbot.utils.MultiQueueWithTopicThreadPool;

public class SoroushBotMultiThreadConsumer
extends SoroushBotAbstractConsumer {
    MultiQueueWithTopicThreadPool threadPool;

    public SoroushBotMultiThreadConsumer(SoroushBotEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.threadPool = new MultiQueueWithTopicThreadPool(endpoint.concurrentConsumers, endpoint.queueCapacityPerThread, "Soroush Thread");
    }

    @Override
    protected void sendExchange(Exchange exchange) {
        try {
            this.threadPool.execute(((SoroushMessage)exchange.getIn().getBody(SoroushMessage.class)).getFrom(), () -> {
                try {
                    if (this.endpoint.isSynchronous()) {
                        this.getProcessor().process(exchange);
                    } else {
                        this.getAsyncProcessor().process(exchange, e -> {});
                    }
                }
                catch (Exception ex) {
                    this.log.error("internal error occurs", (Throwable)ex);
                }
            });
        }
        catch (IllegalStateException ex) {
            throw new CongestionException(ex, (SoroushMessage)exchange.getIn().getBody(SoroushMessage.class));
        }
    }
}

