/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.component;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

class ReconnectableEventSourceListener
extends EventSourceListener {
    private boolean manuallyClosed;
    private OkHttpClient client;
    private final int maxConnectionRetry;
    private int connectionRetry;
    private Request request;
    private final EventSource.Factory factory;
    private EventSource eventSource;

    public ReconnectableEventSourceListener(OkHttpClient client, Request request, int maxConnectionRetry) {
        this.client = client;
        this.maxConnectionRetry = maxConnectionRetry;
        this.request = request;
        this.factory = EventSources.createFactory((OkHttpClient)client);
    }

    public void reconnect() {
        if (!this.manuallyClosed) {
            ++this.connectionRetry;
        } else {
            this.manuallyClosed = false;
        }
        if (this.eventSource != null) {
            this.eventSource.cancel();
        }
        this.connect();
    }

    public void connect() {
        if (!this.onBeforeConnect()) {
            return;
        }
        if (this.maxConnectionRetry >= this.connectionRetry || this.maxConnectionRetry < 0) {
            this.eventSource = this.factory.newEventSource(this.request, (EventSourceListener)this);
        } else {
            this.onFinishProcess();
        }
    }

    public void close() {
        this.manuallyClosed = true;
        this.eventSource.cancel();
    }

    public void onFinishProcess() {
    }

    protected boolean onBeforeConnect() {
        return true;
    }

    public void onOpen(EventSource eventSource, Response response) {
        this.connectionRetry = 0;
    }

    public final void onClosed(EventSource eventSource) {
        if (this.handleClose(eventSource, this.manuallyClosed)) {
            this.reconnect();
        }
    }

    protected boolean handleClose(EventSource eventSource, boolean manuallyClosed) {
        return true;
    }

    public final void onFailure(EventSource eventSource, Throwable t, Response response) {
        if (this.handleFailure(eventSource, this.manuallyClosed, t, response)) {
            this.reconnect();
        }
    }

    protected boolean handleFailure(EventSource eventSource, boolean manuallyClosed, Throwable t, Response response) {
        return true;
    }

    public int getConnectionRetry() {
        return this.connectionRetry;
    }
}

