/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch.converter;

import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.elasticsearch.converter.ElasticsearchActionRequestConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;

public class ElasticsearchActionRequestConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, BulkRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toBulkRequest(value, exchange));
        this.addTypeConverter(registry, DeleteRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toDeleteRequest(value, exchange));
        this.addTypeConverter(registry, GetRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toGetRequest(value, exchange));
        this.addTypeConverter(registry, IndexRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toIndexRequest(value, exchange));
        this.addTypeConverter(registry, SearchRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toSearchRequest(value, exchange));
        this.addTypeConverter(registry, UpdateRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toUpdateRequest(value, exchange));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

