/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;

public class ElasticsearchScrollRequestIterator
implements Iterator<SearchHit>,
Closeable {
    private final SearchRequest searchRequest;
    private final RestHighLevelClient restHighLevelClient;
    private Iterator<SearchHit> currentSearchHits;
    private final int scrollKeepAliveMs;
    private Exchange exchange;
    private String scrollId;
    private boolean closed;
    private int requestCount;

    public ElasticsearchScrollRequestIterator(SearchRequest searchRequest, RestHighLevelClient restHighLevelClient, int scrollKeepAliveMs, Exchange exchange) throws IOException {
        this.searchRequest = searchRequest;
        this.restHighLevelClient = restHighLevelClient;
        this.scrollKeepAliveMs = scrollKeepAliveMs;
        this.exchange = exchange;
        this.closed = false;
        this.requestCount = 0;
        searchRequest.scroll(TimeValue.timeValueMillis((long)scrollKeepAliveMs));
        this.setFirstCurrentSearchHits();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean hasNext = this.currentSearchHits.hasNext();
        if (!hasNext) {
            this.updateCurrentSearchHits();
            hasNext = this.currentSearchHits.hasNext();
        }
        return hasNext;
    }

    @Override
    public SearchHit next() {
        return this.closed ? null : this.currentSearchHits.next();
    }

    private void updateCurrentSearchHits() {
        SearchResponse searchResponse = this.scrollSearch();
        this.currentSearchHits = searchResponse.getHits().iterator();
    }

    private void setFirstCurrentSearchHits() {
        SearchResponse searchResponse = this.firstSearch();
        this.currentSearchHits = searchResponse.getHits().iterator();
        this.scrollId = searchResponse.getScrollId();
    }

    private SearchResponse firstSearch() {
        SearchResponse searchResponse;
        try {
            searchResponse = this.restHighLevelClient.search(this.searchRequest, RequestOptions.DEFAULT);
            ++this.requestCount;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return searchResponse;
    }

    private SearchResponse scrollSearch() {
        SearchResponse searchResponse;
        try {
            SearchScrollRequest searchScrollRequest = new SearchScrollRequest().scroll(new Scroll(TimeValue.timeValueMillis((long)this.scrollKeepAliveMs))).scrollId(this.scrollId);
            searchResponse = this.restHighLevelClient.scroll(searchScrollRequest, RequestOptions.DEFAULT);
            ++this.requestCount;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return searchResponse;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(this.scrollId);
                this.restHighLevelClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                this.closed = true;
                this.exchange.setProperty("CamelElasticsearchScrollQueryCount", (Object)this.requestCount);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

