/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.smpp.MessageReceiverListenerImpl;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppConnectionFactory;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.PDUComposer;

public class SmppConsumer
extends DefaultConsumer {
    private SmppConfiguration configuration;
    private SMPPSession session;
    private MessageReceiverListener messageReceiverListener;
    private SessionStateListener internalSessionStateListener;
    private final ReentrantLock reconnectLock = new ReentrantLock();

    public SmppConsumer(SmppEndpoint endpoint, SmppConfiguration config, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.configuration = config;
        this.internalSessionStateListener = new SessionStateListener(){

            public void onStateChange(SessionState newState, SessionState oldState, Session source) {
                if (SmppConsumer.this.configuration.getSessionStateListener() != null) {
                    SmppConsumer.this.configuration.getSessionStateListener().onStateChange(newState, oldState, source);
                }
                if (newState.equals((Object)SessionState.CLOSED)) {
                    SmppConsumer.this.log.warn("Lost connection to: {} - trying to reconnect...", (Object)SmppConsumer.this.getEndpoint().getConnectionString());
                    SmppConsumer.this.closeSession();
                    SmppConsumer.this.reconnect(SmppConsumer.this.configuration.getInitialReconnectDelay());
                }
            }
        };
        this.messageReceiverListener = new MessageReceiverListenerImpl(this.getEndpoint(), this.getProcessor(), this.getExceptionHandler());
    }

    protected void doStart() throws Exception {
        this.log.debug("Connecting to: {}...", (Object)this.getEndpoint().getConnectionString());
        super.doStart();
        this.session = this.createSession();
        this.log.info("Connected to: {}", (Object)this.getEndpoint().getConnectionString());
    }

    private SMPPSession createSession() throws IOException {
        SMPPSession session = this.createSMPPSession();
        session.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer().intValue());
        session.setTransactionTimer((long)this.configuration.getTransactionTimer().intValue());
        session.addSessionStateListener(this.internalSessionStateListener);
        session.setMessageReceiverListener(this.messageReceiverListener);
        session.connectAndBind(this.configuration.getHost(), this.configuration.getPort().intValue(), new BindParameter(BindType.BIND_RX, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, this.configuration.getAddressRange()));
        return session;
    }

    SMPPSession createSMPPSession() {
        return new SMPPSession((PDUSender)new SynchronizedPDUSender((PDUSender)new DefaultPDUSender((PDUComposer)new DefaultComposer())), (PDUReader)new DefaultPDUReader(), (ConnectionFactory)SmppConnectionFactory.getInstance(this.configuration));
    }

    protected void doStop() throws Exception {
        this.log.debug("Disconnecting from: {}...", (Object)this.getEndpoint().getConnectionString());
        super.doStop();
        this.closeSession();
        this.log.info("Disconnected from: {}", (Object)this.getEndpoint().getConnectionString());
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.removeSessionStateListener(this.internalSessionStateListener);
            this.session.unbindAndClose();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(final long initialReconnectDelay) {
        if (this.reconnectLock.tryLock()) {
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        boolean reconnected = false;
                        SmppConsumer.this.log.info("Schedule reconnect after {} millis", (Object)initialReconnectDelay);
                        try {
                            Thread.sleep(initialReconnectDelay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        int attempt = 0;
                        while (!(SmppConsumer.this.isStopping() || SmppConsumer.this.isStopped() || SmppConsumer.this.session != null && !SmppConsumer.this.session.getSessionState().equals((Object)SessionState.CLOSED) || attempt >= SmppConsumer.this.configuration.getMaxReconnect())) {
                            try {
                                SmppConsumer.this.log.info("Trying to reconnect to {} - attempt #{}", (Object)SmppConsumer.this.getEndpoint().getConnectionString(), (Object)(++attempt));
                                SmppConsumer.this.session = SmppConsumer.this.createSession();
                                reconnected = true;
                            }
                            catch (IOException e) {
                                SmppConsumer.this.log.warn("Failed to reconnect to {}", (Object)SmppConsumer.this.getEndpoint().getConnectionString());
                                SmppConsumer.this.closeSession();
                                try {
                                    Thread.sleep(SmppConsumer.this.configuration.getReconnectDelay());
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        if (reconnected) {
                            SmppConsumer.this.log.info("Reconnected to {}", (Object)SmppConsumer.this.getEndpoint().getConnectionString());
                        }
                    }
                };
                Thread t = new Thread(r);
                t.start();
                t.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.reconnectLock.unlock();
            }
        }
    }

    public String toString() {
        return "SmppConsumer[" + this.getEndpoint().getConnectionString() + "]";
    }

    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }
}

