/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mvel;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.mvel.MvelComponent;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

@UriEndpoint(firstVersion="2.12.0", scheme="mvel", title="MVEL", syntax="mvel:resourceUri", producerOnly=true, label="transformation,script")
public class MvelEndpoint
extends ResourceEndpoint {
    @UriParam
    private String encoding;
    private volatile String template;
    private volatile CompiledTemplate compiled;

    public MvelEndpoint(String uri, MvelComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "mvel:" + this.getResourceUri();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void onExchange(Exchange exchange) throws Exception {
        CompiledTemplate compiled;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = (String)exchange.getIn().getHeader("CamelMvelResourceUri", String.class);
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelMvelResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelMvelResourceUri", (Object)newResourceUri);
            MvelEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        ParserContext mvelContext = ParserContext.create();
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
        String content = (String)exchange.getIn().getHeader("CamelMvelTemplate", String.class);
        if (content != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Mvel content read from header {} for endpoint {}", (Object)"CamelMvelTemplate", (Object)this.getEndpointUri());
            }
            exchange.getIn().removeHeader("CamelMvelTemplate");
            compiled = TemplateCompiler.compileTemplate((String)content, (ParserContext)mvelContext);
        } else {
            InputStreamReader reader;
            String template;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Mvel content read from resource {} with resourceUri: {} for endpoint {}", new Object[]{this.getResourceUri(), path, this.getEndpointUri()});
            }
            if (!(template = IOHelper.toString((Reader)(reader = this.getEncoding() != null ? new InputStreamReader(this.getResourceAsInputStream(), this.getEncoding()) : new InputStreamReader(this.getResourceAsInputStream())))).equals(this.template)) {
                this.template = template;
                this.compiled = TemplateCompiler.compileTemplate((String)template, (ParserContext)mvelContext);
            }
            compiled = this.compiled;
        }
        this.log.debug("Mvel is evaluating using mvel context: {}", (Object)variableMap);
        Object result = TemplateRuntime.execute((CompiledTemplate)compiled, (Object)mvelContext, (Map)variableMap);
        Message out = exchange.getOut();
        out.setBody((Object)result.toString());
        out.setHeaders(exchange.getIn().getHeaders());
        out.setAttachments(exchange.getIn().getAttachments());
    }

    public MvelEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (MvelEndpoint)this.getCamelContext().getEndpoint(newUri, MvelEndpoint.class);
    }
}

